/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class ShortBlitter
implements Blitter {
    private ShortProcessor ip;
    private int width;
    private int height;
    private short[] pixels;

    public void setTransparentColor(Color c) {
    }

    public ShortBlitter(ShortProcessor ip) {
        this.ip = ip;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.pixels = (short[])ip.getPixels();
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        int srcWidth = ip.getWidth();
        int srcHeight = ip.getHeight();
        Rectangle r1 = new Rectangle(srcWidth, srcHeight);
        r1.setLocation(xloc, yloc);
        Rectangle r2 = new Rectangle(this.width, this.height);
        if (!r1.intersects(r2)) {
            return;
        }
        short[] srcPixels = (short[])ip.getPixels();
        r1 = r1.intersection(r2);
        int xSrcBase = xloc < 0 ? -xloc : 0;
        int ySrcBase = yloc < 0 ? -yloc : 0;
        block15: for (int y = r1.y; y < r1.y + r1.height; ++y) {
            int srcIndex = (y - yloc) * srcWidth + (r1.x - xloc);
            int dstIndex = y * this.width + r1.x;
            switch (mode) {
                case 0: 
                case 1: 
                case 2: {
                    int i = r1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex++] = srcPixels[srcIndex++];
                    }
                    continue block15;
                }
                case 14: {
                    int dst;
                    int src;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = (src = srcPixels[srcIndex++] & 0xFFFF) == 0 ? this.pixels[dstIndex] : src;
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 3: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (srcPixels[srcIndex++] & 0xFFFF) + (this.pixels[dstIndex] & 0xFFFF)) < 0) {
                            dst = 0;
                        }
                        if (dst > 65535) {
                            dst = 65535;
                        }
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 7: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = ((srcPixels[srcIndex++] & 0xFFFF) + (this.pixels[dstIndex] & 0xFFFF)) / 2;
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 8: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (this.pixels[dstIndex] & 0xFFFF) - (srcPixels[srcIndex++] & 0xFFFF)) < 0) {
                            dst = -dst;
                        }
                        if (dst > 65535) {
                            dst = 65535;
                        }
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 4: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (this.pixels[dstIndex] & 0xFFFF) - (srcPixels[srcIndex++] & 0xFFFF)) < 0) {
                            dst = 0;
                        }
                        if (dst > 65535) {
                            dst = 65535;
                        }
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 5: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        if ((dst = (srcPixels[srcIndex++] & 0xFFFF) * (this.pixels[dstIndex] & 0xFFFF)) < 0) {
                            dst = 0;
                        }
                        if (dst > 65535) {
                            dst = 65535;
                        }
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 6: {
                    int dst;
                    int src;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = (src = srcPixels[srcIndex++] & 0xFFFF) == 0 ? 65535 : (this.pixels[dstIndex] & 0xFFFF) / src;
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 9: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = srcPixels[srcIndex++] & this.pixels[dstIndex] & 0xFFFF;
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 10: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = srcPixels[srcIndex++] | this.pixels[dstIndex];
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 11: {
                    int dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = srcPixels[srcIndex++] ^ this.pixels[dstIndex];
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 12: {
                    int dst;
                    int src;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = this.pixels[dstIndex] & 0xFFFF;
                        if ((src = srcPixels[srcIndex++] & 0xFFFF) < dst) {
                            dst = src;
                        }
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
                case 13: {
                    int dst;
                    int src;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = this.pixels[dstIndex] & 0xFFFF;
                        if ((src = srcPixels[srcIndex++] & 0xFFFF) > dst) {
                            dst = src;
                        }
                        this.pixels[dstIndex++] = (short)dst;
                    }
                    continue block15;
                }
            }
        }
    }
}

