/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.BitField;
import loci.poi.util.BitFieldFactory;
import loci.poi.util.LittleEndian;

public class WindowOneRecord
extends Record {
    public static final short sid = 61;
    private short field_1_h_hold;
    private short field_2_v_hold;
    private short field_3_width;
    private short field_4_height;
    private short field_5_options;
    private static final BitField hidden = BitFieldFactory.getInstance(1);
    private static final BitField iconic = BitFieldFactory.getInstance(2);
    private static final BitField reserved = BitFieldFactory.getInstance(4);
    private static final BitField hscroll = BitFieldFactory.getInstance(8);
    private static final BitField vscroll = BitFieldFactory.getInstance(16);
    private static final BitField tabs = BitFieldFactory.getInstance(32);
    private short field_6_selected_tab;
    private short field_7_displayed_tab;
    private short field_8_num_selected_tabs;
    private short field_9_tab_width_ratio;

    public WindowOneRecord() {
    }

    public WindowOneRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 61) {
            throw new RecordFormatException("NOT A WINDOW1 RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_h_hold = in.readShort();
        this.field_2_v_hold = in.readShort();
        this.field_3_width = in.readShort();
        this.field_4_height = in.readShort();
        this.field_5_options = in.readShort();
        this.field_6_selected_tab = in.readShort();
        this.field_7_displayed_tab = in.readShort();
        this.field_8_num_selected_tabs = in.readShort();
        this.field_9_tab_width_ratio = in.readShort();
    }

    public void setHorizontalHold(short h) {
        this.field_1_h_hold = h;
    }

    public void setVerticalHold(short v) {
        this.field_2_v_hold = v;
    }

    public void setWidth(short w) {
        this.field_3_width = w;
    }

    public void setHeight(short h) {
        this.field_4_height = h;
    }

    public void setOptions(short o) {
        this.field_5_options = o;
    }

    public void setHidden(boolean ishidden) {
        this.field_5_options = hidden.setShortBoolean(this.field_5_options, ishidden);
    }

    public void setIconic(boolean isiconic) {
        this.field_5_options = iconic.setShortBoolean(this.field_5_options, isiconic);
    }

    public void setDisplayHorizonalScrollbar(boolean scroll) {
        this.field_5_options = hscroll.setShortBoolean(this.field_5_options, scroll);
    }

    public void setDisplayVerticalScrollbar(boolean scroll) {
        this.field_5_options = vscroll.setShortBoolean(this.field_5_options, scroll);
    }

    public void setDisplayTabs(boolean disptabs) {
        this.field_5_options = tabs.setShortBoolean(this.field_5_options, disptabs);
    }

    public void setSelectedTab(short s) {
        this.field_6_selected_tab = s;
    }

    public void setDisplayedTab(short t) {
        this.field_7_displayed_tab = t;
    }

    public void setNumSelectedTabs(short n) {
        this.field_8_num_selected_tabs = n;
    }

    public void setTabWidthRatio(short r) {
        this.field_9_tab_width_ratio = r;
    }

    public short getHorizontalHold() {
        return this.field_1_h_hold;
    }

    public short getVerticalHold() {
        return this.field_2_v_hold;
    }

    public short getWidth() {
        return this.field_3_width;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean getHidden() {
        return hidden.isSet(this.field_5_options);
    }

    public boolean getIconic() {
        return iconic.isSet(this.field_5_options);
    }

    public boolean getDisplayHorizontalScrollbar() {
        return hscroll.isSet(this.field_5_options);
    }

    public boolean getDisplayVerticalScrollbar() {
        return vscroll.isSet(this.field_5_options);
    }

    public boolean getDisplayTabs() {
        return tabs.isSet(this.field_5_options);
    }

    public short getSelectedTab() {
        return this.field_6_selected_tab;
    }

    public short getDisplayedTab() {
        return this.field_7_displayed_tab;
    }

    public short getNumSelectedTabs() {
        return this.field_8_num_selected_tabs;
    }

    public short getTabWidthRatio() {
        return this.field_9_tab_width_ratio;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WINDOW1]\n");
        buffer.append("    .h_hold          = ").append(Integer.toHexString(this.getHorizontalHold())).append("\n");
        buffer.append("    .v_hold          = ").append(Integer.toHexString(this.getVerticalHold())).append("\n");
        buffer.append("    .width           = ").append(Integer.toHexString(this.getWidth())).append("\n");
        buffer.append("    .height          = ").append(Integer.toHexString(this.getHeight())).append("\n");
        buffer.append("    .options         = ").append(Integer.toHexString(this.getOptions())).append("\n");
        buffer.append("        .hidden      = ").append(this.getHidden()).append("\n");
        buffer.append("        .iconic      = ").append(this.getIconic()).append("\n");
        buffer.append("        .hscroll     = ").append(this.getDisplayHorizontalScrollbar()).append("\n");
        buffer.append("        .vscroll     = ").append(this.getDisplayVerticalScrollbar()).append("\n");
        buffer.append("        .tabs        = ").append(this.getDisplayTabs()).append("\n");
        buffer.append("    .selectedtab     = ").append(Integer.toHexString(this.getSelectedTab())).append("\n");
        buffer.append("    .displayedtab    = ").append(Integer.toHexString(this.getDisplayedTab())).append("\n");
        buffer.append("    .numselectedtabs = ").append(Integer.toHexString(this.getNumSelectedTabs())).append("\n");
        buffer.append("    .tabwidthratio   = ").append(Integer.toHexString(this.getTabWidthRatio())).append("\n");
        buffer.append("[/WINDOW1]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)61);
        LittleEndian.putShort(data, 2 + offset, (short)18);
        LittleEndian.putShort(data, 4 + offset, this.getHorizontalHold());
        LittleEndian.putShort(data, 6 + offset, this.getVerticalHold());
        LittleEndian.putShort(data, 8 + offset, this.getWidth());
        LittleEndian.putShort(data, 10 + offset, this.getHeight());
        LittleEndian.putShort(data, 12 + offset, this.getOptions());
        LittleEndian.putShort(data, 14 + offset, this.getSelectedTab());
        LittleEndian.putShort(data, 16 + offset, this.getDisplayedTab());
        LittleEndian.putShort(data, 18 + offset, this.getNumSelectedTabs());
        LittleEndian.putShort(data, 20 + offset, this.getTabWidthRatio());
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 22;
    }

    @Override
    public short getSid() {
        return 61;
    }
}

