/*
 * Decompiled with CFR 0.152.
 */
package ome.util.math.geom2D;

public class PlanePoint {
    public final double x1;
    public final double x2;

    public PlanePoint(double x1, double x2) {
        this.x1 = x1;
        this.x2 = x2;
    }

    public double distance(PlanePoint p) {
        PlanePoint tp = this.vec(p);
        return tp.norm();
    }

    public PlanePoint sum(PlanePoint vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        return new PlanePoint(this.x1 + vec.x1, this.x2 + vec.x2);
    }

    public PlanePoint diff(PlanePoint vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        return new PlanePoint(this.x1 - vec.x1, this.x2 - vec.x2);
    }

    public PlanePoint scalar(double k) {
        return new PlanePoint(k * this.x1, k * this.x2);
    }

    public PlanePoint vec(PlanePoint p) {
        if (p == null) {
            throw new NullPointerException("No point.");
        }
        return new PlanePoint(p.x1 - this.x1, p.x2 - this.x2);
    }

    public PlanePoint vec(double x1, double x2) {
        return new PlanePoint(x1 - this.x1, x2 - this.x2);
    }

    public double dot(PlanePoint vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        return this.x1 * vec.x1 + this.x2 * vec.x2;
    }

    public double norm() {
        return Math.sqrt(this.dot(this));
    }

    public PlanePoint normalize() {
        double n = this.norm();
        if (n == 0.0) {
            return this;
        }
        return new PlanePoint(this.x1 / n, this.x2 / n);
    }

    public double angle(PlanePoint vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        double thisNorm = this.norm();
        double vecNorm = vec.norm();
        double dotPrd = this.dot(vec);
        if (thisNorm == 0.0 || vecNorm == 0.0) {
            throw new IllegalArgumentException("The angle is not defined for a null vector.");
        }
        return Math.acos(dotPrd / (thisNorm * vecNorm));
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof PlanePoint) {
            PlanePoint other = (PlanePoint)o;
            isEqual = this.x1 == other.x1 && this.x2 == other.x2;
        }
        return isEqual;
    }

    public boolean equals(double x1, double x2) {
        return this.x1 == x1 && this.x2 == x2;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x1);
        return (int)(bits ^= Double.doubleToLongBits(this.x2) * 31L) ^ (int)(bits >> 32);
    }
}

