/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.AdminView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;

public abstract class DataImporterLoader
extends DSCallAdapter {
    protected final Importer viewer;
    protected final Registry registry;
    protected final ImageDataView ivView;
    protected final MetadataHandlerView mhView;
    protected final AdminView adminView;
    protected final DataManagerView dmView;
    protected final HierarchyBrowsingView hiBrwView;
    protected long userID;
    protected long groupID;
    protected final SecurityContext ctx;

    protected long getCurrentUserID() {
        return ImporterAgent.getUserDetails().getId();
    }

    protected DataImporterLoader(Importer viewer, SecurityContext ctx) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.ctx = ctx;
        this.registry = ImporterAgent.getRegistry();
        this.ivView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.adminView = (AdminView)this.registry.getDataServicesView(AdminView.class);
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
        this.hiBrwView = (HierarchyBrowsingView)this.registry.getDataServicesView(HierarchyBrowsingView.class);
    }

    @Override
    public void onEnd() {
    }

    @Override
    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public abstract void load();

    public abstract void cancel();
}

