/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ome.xml.model.Experimenter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.ExperimenterListModel;

public class ExperimenterBox
extends Box
implements KeyListener {
    private JList list;
    private JTextField txtField;
    private boolean userInput;
    private int editRow;

    public ExperimenterBox(int axis) {
        super(axis);
        this.userInput = false;
    }

    public ExperimenterBox(List<Experimenter> m) {
        super(1);
        this.editRow = -1;
        this.userInput = false;
        this.txtField = new JTextField();
        this.txtField.addKeyListener(this);
        this.txtField.setToolTipText("<FirstName LastName> \n Please type enter after input!");
        ExperimenterListModel model = new ExperimenterListModel();
        model.setList(m);
        this.list = new JList<String>(model);
        this.list.setVisibleRowCount(4);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    JList list = (JList)e.getSource();
                    int row = list.locationToIndex(e.getPoint());
                    ExperimenterBox.this.editElement(row);
                    ExperimenterBox.this.userInput = true;
                }
            }
        });
        this.list.addKeyListener(this);
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add(this.txtField);
        this.add(scrollPane);
    }

    protected void editElement(int row) {
        this.txtField.setText((String)this.list.getSelectedValue());
        this.editRow = this.list.getSelectedIndex();
    }

    public void addElement(Experimenter e) {
        ExperimenterListModel m = (ExperimenterListModel)this.list.getModel();
        m.addElement(e);
        this.list.setModel(m);
    }

    public void addExperimenterList(List<Experimenter> newList) {
        if (newList == null) {
            return;
        }
        ((ExperimenterListModel)this.list.getModel()).setList(newList);
    }

    public List<Experimenter> getExperimenterList() {
        return ((ExperimenterListModel)this.list.getModel()).getList();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        this.userInput = true;
        if (e.getSource() == this.txtField && key == 10) {
            boolean append = true;
            String item = this.txtField.getText().toLowerCase();
            ExperimenterListModel m = (ExperimenterListModel)this.list.getModel();
            int elementIndex = m.elementExists(item);
            boolean bl = append = elementIndex <= -1;
            if (append) {
                Experimenter ex = null;
                String str = this.txtField.getText();
                if (str != null && str.length() > 0) {
                    String[] split = str.split("\\s+");
                    if (split.length > 1) {
                        ex = new Experimenter();
                        ex.setFirstName(split[0]);
                        ex.setLastName(split[1]);
                    } else {
                        return;
                    }
                }
                if (this.editRow == -1) {
                    this.addElement(ex);
                    this.txtField.setText("");
                    this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
                } else {
                    m.replace(this.editRow, ex);
                    this.list.setModel(m);
                    this.editRow = -1;
                }
            } else {
                this.list.setSelectedValue(m.getElementAt(elementIndex), true);
            }
        }
        if (e.getSource() == this.list && key == 127) {
            ExperimenterListModel m = (ExperimenterListModel)this.list.getModel();
            m.removeExperimenter(this.list.getSelectedIndex());
            this.list.setModel(m);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void setBackground(Color c) {
        this.txtField.setBackground(c);
        this.list.setBackground(c);
    }

    public boolean valueChanged() {
        return this.userInput;
    }
}

