/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.Dimension;
import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import ome.conditions.ResourceError;
import omero.MissingPyramidException;
import omero.ServerError;
import omero.api.RawPixelsStorePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.log.LogMessage;
import omero.rtypes;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.EncoderException;
import org.openmicroscopy.shoola.util.image.io.WriterImage;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class ThumbnailLoader
extends BatchCallTree {
    private Collection<DataObject> images;
    private int maxWidth;
    private int maxHeight;
    private Object currentThumbnail;
    private Collection<Long> userIDs;
    private OmeroImageService service;
    private SecurityContext ctx;
    private boolean asImage = false;
    private boolean readOnly = false;

    private boolean isReadOnly() {
        String b = (String)this.context.lookup("omero.cluster.read_only.runtime.db");
        if (b != null) {
            return Boolean.valueOf(b);
        }
        return false;
    }

    public ThumbnailLoader(SecurityContext ctx, Collection<DataObject> imgs, int maxWidth, int maxHeight, Collection<Long> userIDs) {
        if (imgs == null) {
            throw new NullPointerException("No images.");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.images = imgs;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.userIDs = userIDs;
        this.ctx = ctx;
        this.service = this.context.getImageService();
        this.readOnly = this.isReadOnly();
    }

    public ThumbnailLoader(SecurityContext ctx, Collection<DataObject> imgs, long userID) {
        this(ctx, imgs, 0, 0, Collections.singleton(userID));
        this.asImage = true;
    }

    public ThumbnailLoader(SecurityContext ctx, Collection<DataObject> imgs, int maxWidth, int maxHeight, long userID) {
        this(ctx, imgs, maxWidth, maxHeight, Collections.singleton(userID));
    }

    public ThumbnailLoader(SecurityContext ctx, ImageData image, int maxWidth, int maxHeight, long userID) {
        this(ctx, new HashSet<DataObject>(), maxWidth, maxHeight, Collections.singleton(userID));
        this.images.add(image);
    }

    public ThumbnailLoader(SecurityContext ctx, ImageData image, int maxWidth, int maxHeight, Collection<Long> userIDs) {
        this(ctx, new HashSet<DataObject>(), maxWidth, maxHeight, userIDs);
        this.images.add(image);
    }

    @Override
    protected Object getResult() {
        return this.currentThumbnail;
    }

    @Override
    protected Object getPartialResult() {
        return this.currentThumbnail;
    }

    @Override
    protected void buildTree() {
        int lastIndex = this.images.size() - 1;
        for (final long userId : this.userIDs) {
            int k = 0;
            for (DataObject image : this.images) {
                PixelsData pxd;
                if (image == null || (pxd = this.dataObjectToPixelsData(image)) == null) continue;
                final boolean last = lastIndex == k++;
                BatchCall call = new BatchCall("Loading thumbnails"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doCall() throws Exception {
                        ThumbnailStorePrx store = null;
                        try {
                            store = ThumbnailLoader.this.getThumbnailStore(pxd);
                            ThumbnailLoader.this.handleBatchCall(store, pxd, userId);
                        }
                        catch (Exception e) {
                            ThumbnailLoader.this.currentThumbnail = new ThumbnailData(pxd.getImage().getId(), ThumbnailLoader.this.getErrorIcon(), userId, false);
                            LogMessage msg = new LogMessage("Couldn't initialize the ThumbnailStore for pixels id " + pxd.getId(), (Throwable)e);
                            ThumbnailLoader.this.context.getLogger().warn((Object)this, msg);
                        }
                        finally {
                            if (last && store != null) {
                                ThumbnailLoader.this.context.getDataService().closeService(ThumbnailLoader.this.ctx, (StatefulServiceInterfacePrx)store);
                            }
                        }
                    }
                };
                this.add(call);
            }
        }
    }

    private void handleBatchCall(ThumbnailStorePrx store, PixelsData pxd, long userId) throws DSOutOfServiceException, DSAccessException {
        Image thumbnail = null;
        try {
            byte[] thumbnailData = this.loadThumbnail(store, pxd, userId);
            thumbnail = thumbnailData == null || thumbnailData.length == 0 ? (this.requiresPixelsPyramid(pxd) ? this.determineThumbnailState(pxd) : this.getLoadingIcon()) : WriterImage.bytesToImage(thumbnailData);
        }
        catch (ServerError e) {
            this.context.getLogger().error((Object)this, new LogMessage("API error", (Throwable)e));
        }
        catch (EncoderException e) {
            this.context.getLogger().error((Object)this, new LogMessage("Failed to convert thumbnail byte array to BufferedImage", (Throwable)e));
        }
        if (thumbnail == null) {
            thumbnail = this.getErrorIcon();
        }
        this.currentThumbnail = new ThumbnailData(pxd.getImage().getId(), thumbnail, userId, true);
    }

    private PixelsData dataObjectToPixelsData(DataObject image) {
        return image instanceof ImageData ? ((ImageData)image).getDefaultPixels() : (PixelsData)image;
    }

    private Image determineThumbnailState(PixelsData pxd) throws DSOutOfServiceException, ServerError {
        RawPixelsStorePrx rawPixelStore = this.context.getGateway().getPixelsStore(this.ctx);
        try {
            rawPixelStore.setPixelsId(pxd.getId(), false);
        }
        catch (MissingPyramidException e) {
            return this.getLoadingIcon();
        }
        catch (ResourceError e) {
            this.context.getLogger().error((Object)this, new LogMessage("Error getting pyramid from server, it might be corrupt", (Throwable)e));
        }
        return this.getErrorIcon();
    }

    private ThumbnailStorePrx getThumbnailStore(PixelsData pxd) throws DSAccessException, DSOutOfServiceException, ServerError {
        ThumbnailStorePrx store = this.service.createThumbnailStore(this.ctx);
        if (!store.setPixelsId(pxd.getId())) {
            store.resetDefaults();
            store.setPixelsId(pxd.getId());
        }
        return store;
    }

    private byte[] loadThumbnail(ThumbnailStorePrx store, PixelsData pxd, long userId) throws ServerError, DSAccessException, DSOutOfServiceException {
        long rndDefId;
        int sizeX = this.maxWidth;
        int sizeY = this.maxHeight;
        if (this.asImage) {
            sizeX = pxd.getSizeX();
            sizeY = pxd.getSizeY();
        } else {
            Dimension d = Factory.computeThumbnailSize(sizeX, sizeY, pxd.getSizeX(), pxd.getSizeY());
            sizeX = d.width;
            sizeY = d.height;
        }
        if (userId >= 0L && (rndDefId = this.service.getRenderingDef(this.ctx, pxd.getId(), userId).longValue()) >= 0L) {
            store.setRenderingDefId(rndDefId);
        }
        if (this.readOnly) {
            return store.getThumbnail(rtypes.rint((int)sizeX), rtypes.rint((int)sizeY));
        }
        return store.getThumbnailWithoutDefault(rtypes.rint((int)sizeX), rtypes.rint((int)sizeY));
    }

    private boolean requiresPixelsPyramid(PixelsData pxd) {
        int maxWidth = (Integer)this.context.lookup("/services/Thumbnailing/non_pyramid_max_plane_width");
        int maxHeight = (Integer)this.context.lookup("/services/Thumbnailing/non_pyramid_max_plane_height");
        return pxd.getSizeX() * pxd.getSizeY() > maxWidth * maxHeight;
    }

    private Image getLoadingIcon() {
        return IconManager.getInstance().getIcon(164).getImage();
    }

    private Image getErrorIcon() {
        return IconManager.getInstance().getIcon(163).getImage();
    }
}

