/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file.modulo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.file.modulo.ModuloInfo;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModuloParser {
    private static String[] tagsModulo = new String[]{"ModuloAlongC", "ModuloAlongZ", "ModuloAlongT"};
    private String file;
    private List<ModuloInfo> modulos;
    private List<Node> moduloTags;
    private Document document;

    private void readModuloEntries() {
        for (int k = 0; k < tagsModulo.length; ++k) {
            NodeList list = this.document.getElementsByTagName(tagsModulo[k]);
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!n.hasAttributes()) continue;
                this.moduloTags.add(n);
            }
        }
    }

    ModuloInfo createModuloFor(Node tag) throws Exception {
        Node attribute;
        if (!tag.hasAttributes()) {
            throw new Exception("Missing tag's attributes.");
        }
        ModuloInfo info = new ModuloInfo(tag.getNodeName());
        NamedNodeMap attributes = tag.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attribute = attributes.item(i);
            if ("Start".equals(attribute.getNodeName())) {
                info.setStart(Double.parseDouble(attribute.getNodeValue()));
                continue;
            }
            if ("End".equals(attribute.getNodeName())) {
                info.setEnd(Double.parseDouble(attribute.getNodeValue()));
                continue;
            }
            if ("Step".equals(attribute.getNodeName())) {
                info.setStep(Double.parseDouble(attribute.getNodeValue()));
                continue;
            }
            if ("Type".equals(attribute.getNodeName())) {
                info.setType(attribute.getNodeValue());
                continue;
            }
            if ("TypeDescription".equals(attribute.getNodeName())) {
                info.setTypeDescription(attribute.getNodeValue());
                continue;
            }
            if (!"Unit".equals(attribute.getNodeName())) continue;
            info.setUnit(attribute.getNodeValue());
        }
        NodeList nodes = tag.getChildNodes();
        Double min = Double.MAX_VALUE;
        Double max = Double.MIN_VALUE;
        ArrayList<Double> labels = new ArrayList<Double>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            attribute = nodes.item(i);
            if (attribute.getNodeType() != 1 || !"Label".equals(attribute.getNodeName())) continue;
            Double v = Double.parseDouble(attribute.getFirstChild().getNodeValue());
            if (v < min) {
                min = v;
            }
            if (v > max) {
                max = v;
            }
            labels.add(v);
        }
        if (!CollectionUtils.isEmpty(labels)) {
            info.setStart(min);
            info.setEnd(max);
            info.setLabels(labels);
        }
        return info;
    }

    public ModuloParser(String file) {
        if (CommonsLangUtils.isEmpty(file)) {
            throw new IllegalArgumentException("No file to parse.");
        }
        this.file = file;
        this.modulos = new ArrayList<ModuloInfo>();
        this.moduloTags = new ArrayList<Node>();
    }

    public void parse() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        BufferedWriter out = null;
        File f = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            f = File.createTempFile("modulo", ".xml");
            out = new BufferedWriter(new FileWriter(f));
            out.write(this.file);
            out.close();
            out = null;
            this.document = builder.parse(f);
            this.readModuloEntries();
            for (Node node : this.moduloTags) {
                ModuloInfo entry = this.createModuloFor(node);
                if (entry == null) continue;
                this.modulos.add(entry);
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot read the file", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (f != null) {
                f.delete();
            }
        }
    }

    public List<ModuloInfo> getModulos() {
        return this.modulos;
    }
}

