/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.io;

import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import org.openmicroscopy.shoola.util.image.io.EncoderException;

public abstract class Encoder {
    static final int RED_BAND = 0;
    static final int GREEN_BAND = 1;
    static final int BLUE_BAND = 2;
    protected DataOutputStream output;
    protected BufferedImage image;
    protected int imageWidth;
    protected int imageHeight;
    protected int colorType;

    private int checkColorModel(BufferedImage img) {
        int c = img.getColorModel().getColorSpace().getType();
        if (c != 5 && c != 6) {
            throw new IllegalArgumentException("Color Type not supported");
        }
        return c;
    }

    public Encoder(BufferedImage image, DataOutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not valid");
        }
        if (image == null) {
            throw new IllegalArgumentException("Image to encode not valid");
        }
        this.colorType = this.checkColorModel(image);
        this.image = image;
        this.imageHeight = image.getWidth();
        this.imageWidth = image.getHeight();
        this.output = output;
        this.init();
    }

    public DataOutputStream getOutput() {
        return this.output;
    }

    public abstract void write() throws EncoderException;

    protected abstract void init();
}

