/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class FormatHighlighter
implements Highlighter.HighlightPainter {
    private int thickness;

    FormatHighlighter() {
        this(2);
    }

    FormatHighlighter(int thickness) {
        this.thickness = thickness;
    }

    private void paintLine(Graphics g, Rectangle r, int x2) {
        int ytop = r.y + r.height - 3;
        g.fillRect(r.x, ytop, x2 - r.x, this.thickness);
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        Rectangle r0 = null;
        Rectangle r1 = null;
        Rectangle rbounds = bounds.getBounds();
        int xmax = rbounds.x + rbounds.width;
        try {
            r0 = c.modelToView(p0);
            r1 = c.modelToView(p1);
        }
        catch (BadLocationException ex) {
            return;
        }
        if (r0 == null || r1 == null) {
            return;
        }
        g.setColor(c.getSelectionColor());
        if (r0.y == r1.y) {
            this.paintLine(g, r0, r1.x);
            return;
        }
        this.paintLine(g, r0, xmax);
        r0.y += r0.height;
        r0.x = rbounds.x;
        while (r0.y < r1.y) {
            this.paintLine(g, r0, xmax);
            r0.y += r0.height;
        }
        this.paintLine(g, r0, r1.x);
    }
}

