/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.util.Arrays;
import omeis.providers.re.RGBBuffer;

public class RGBIntBuffer
extends RGBBuffer {
    private static final long serialVersionUID = 5319594152389817324L;
    private int[] dataBuf;
    private int sizeX1;
    private int sizeX2;

    public RGBIntBuffer(int sizeX1, int sizeX2) {
        this.sizeX1 = sizeX1;
        this.sizeX2 = sizeX2;
        try {
            this.dataBuf = new int[Math.multiplyExact(sizeX1, sizeX2)];
        }
        catch (ArithmeticException ae) {
            throw new IllegalArgumentException(sizeX1 + "\u00d7" + sizeX2 + " plane too large, cannot exceed 2^31 pixels");
        }
    }

    @Override
    public void setRedValue(int index, int value) {
        this.dataBuf[index] = this.dataBuf[index] | value << 16;
    }

    @Override
    public void setGreenValue(int index, int value) {
        this.dataBuf[index] = this.dataBuf[index] | value << 8;
    }

    @Override
    public void setBlueValue(int index, int value) {
        this.dataBuf[index] = this.dataBuf[index] | value;
    }

    @Override
    public byte getRedValue(int index) {
        return (byte)((this.dataBuf[index] & 0xFF0000) >> 16);
    }

    @Override
    public byte getGreenValue(int index) {
        return (byte)((this.dataBuf[index] & 0xFF00) >> 8);
    }

    @Override
    public byte getBlueValue(int index) {
        return (byte)(this.dataBuf[index] & 0xFF);
    }

    public int[] getDataBuffer() {
        return this.dataBuf;
    }

    @Override
    public void zero() {
        Arrays.fill(this.dataBuf, 0);
    }
}

