/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Instrument;
import ome.model.annotations.Annotation;
import ome.model.annotations.LightSourceAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.units.Power;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="lightsource_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="lightsource_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="lightsource_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="lightsource_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="lightsource_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="lightsource_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="lightsource_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="lightsource_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="lightsource_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="lightsource_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="lightsource_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="lightsource_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT lightsource.id FROM lightsource*, image* WHERE lightsource.instrument = image.instrument AND image.id IN (:images)))")})
@Entity
@Table(name="lightsource", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_lightsource", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_lightsource"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public abstract class LightSource
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "lightsource_owner_filter";
    public static final String GROUP_FILTER = "lightsource_group_filter";
    public static final String EVENT_FILTER = "lightsource_event_filter";
    public static final String PERMS_FILTER = "lightsource_perms_filter";
    public static final String ID = "ome.model.acquisition.LightSource_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.LightSource_version";
    protected Integer version = 0;
    protected String manufacturer = null;
    protected String model = null;
    protected Power power = null;
    protected String lotNumber = null;
    protected String serialNumber = null;
    protected Instrument instrument = null;
    protected Set<LightSourceAnnotationLink> annotationLinks = new HashSet<LightSourceAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "lightsource_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "lightsource_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "lightsource_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "lightsource_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String MANUFACTURER = "ome.model.acquisition.LightSource_manufacturer";
    public static final String MODEL = "ome.model.acquisition.LightSource_model";
    public static final String POWER = "ome.model.acquisition.LightSource_power";
    public static final String LOTNUMBER = "ome.model.acquisition.LightSource_lotNumber";
    public static final String SERIALNUMBER = "ome.model.acquisition.LightSource_serialNumber";
    public static final String INSTRUMENT = "ome.model.acquisition.LightSource_instrument";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.acquisition.LightSource_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.acquisition.LightSource_annotationLinks";
    public static final String DETAILS = "ome.model.acquisition.LightSource_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public LightSource() {
        this(null, true);
    }

    protected LightSource(Long id) {
        this(id, true);
    }

    public LightSource(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public LightSource(Instrument _instrument) {
        this(null, true);
        this.setInstrument(_instrument);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_lightsource")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="manufacturer", updatable=true)
    public String getManufacturer() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.manufacturer = manufacturer;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="model", updatable=true)
    public String getModel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.model;
    }

    public void setModel(String model) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.model = model;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="\"power\"")), @AttributeOverride(name="unit", column=@Column(name="powerUnit"))})
    public Power getPower() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.power;
    }

    public void setPower(Power power) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.power = power;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="lotNumber", updatable=true)
    public String getLotNumber() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lotNumber;
    }

    public void setLotNumber(String lotNumber) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lotNumber = lotNumber;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="serialNumber", updatable=true)
    public String getSerialNumber() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.serialNumber = serialNumber;
    }

    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Instrument.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="instrument", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlightsource_instrument_instrument")
    public Instrument getInstrument() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.instrument = instrument;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="lightsource_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="lightsource_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="lightsource_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="lightsource_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<LightSourceAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<LightSourceAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<LightSourceAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<LightSourceAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<LightSourceAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<LightSourceAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addLightSourceAnnotationLink(LightSourceAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addLightSourceAnnotationLinkSet(Collection<LightSourceAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (LightSourceAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeLightSourceAnnotationLink(LightSourceAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeLightSourceAnnotationLinkSet(Collection<LightSourceAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (LightSourceAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public LightSourceAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        LightSourceAnnotationLink link = new LightSourceAnnotationLink();
        link.link(this, addition);
        this.addLightSourceAnnotationLink(link, true);
        return link;
    }

    public void addLightSourceAnnotationLink(LightSourceAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<LightSourceAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                LightSourceAnnotationLink link = (LightSourceAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<LightSourceAnnotationLink> findLightSourceAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<LightSourceAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<LightSourceAnnotationLink> result = new HashSet<LightSourceAnnotationLink>();
        while (it.hasNext()) {
            LightSourceAnnotationLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<LightSourceAnnotationLink> toRemove = this.findLightSourceAnnotationLink(removal);
        Iterator<LightSourceAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeLightSourceAnnotationLink(it.next(), true);
        }
    }

    public void removeLightSourceAnnotationLink(LightSourceAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<LightSourceAnnotationLink> list = new ArrayList<LightSourceAnnotationLink>(this.getAnnotationLinks());
        for (LightSourceAnnotationLink link : list) {
            this.removeLightSourceAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_LightSource_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_LightSource_annotationLinks_by_owner", joinColumns={@JoinColumn(name="LightSource_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.manufacturer = (String)__filter.filter(MANUFACTURER, this.manufacturer);
            this.model = (String)__filter.filter(MODEL, this.model);
            this.power = (Power)__filter.filter(POWER, this.power);
            this.lotNumber = (String)__filter.filter(LOTNUMBER, this.lotNumber);
            this.serialNumber = (String)__filter.filter(SERIALNUMBER, this.serialNumber);
            this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(MANUFACTURER)) {
            return this.getManufacturer();
        }
        if (field.equals(MODEL)) {
            return this.getModel();
        }
        if (field.equals(POWER)) {
            return this.getPower();
        }
        if (field.equals(LOTNUMBER)) {
            return this.getLotNumber();
        }
        if (field.equals(SERIALNUMBER)) {
            return this.getSerialNumber();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(MANUFACTURER)) {
            this.setManufacturer((String)value);
        } else if (field.equals(MODEL)) {
            this.setModel((String)value);
        } else if (field.equals(POWER)) {
            this.setPower((Power)value);
        } else if (field.equals(LOTNUMBER)) {
            this.setLotNumber((String)value);
        } else if (field.equals(SERIALNUMBER)) {
            this.setSerialNumber((String)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.manufacturer = null;
        this.model = null;
        this.power = null;
        this.lotNumber = null;
        this.serialNumber = null;
        this.instrument = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(MANUFACTURER);
        raw.add(MODEL);
        raw.add(POWER);
        raw.add(LOTNUMBER);
        raw.add(SERIALNUMBER);
        raw.add(INSTRUMENT);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKlightsource_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlightsource_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKlightsource_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlightsource_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlightsource_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

