/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd;

import Ice.Current;
import Ice.Identity;
import Ice.Util;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import ome.conditions.InternalException;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import omero.LockTimeout;
import omero.ServerError;
import omero.cmd.CmdCallbackPrx;
import omero.cmd.CmdCallbackPrxHelper;
import omero.cmd.ERR;
import omero.cmd.Helper;
import omero.cmd.IHandle;
import omero.cmd.IRequest;
import omero.cmd.Request;
import omero.cmd.Response;
import omero.cmd.SessionAware;
import omero.cmd.SessionI;
import omero.cmd.Status;
import omero.cmd._HandleOperations;
import org.hibernate.Session;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class HandleI
implements _HandleOperations,
IHandle,
SessionAware {
    private static final long serialVersionUID = 15920349984928755L;
    private static final MapMaker mapMaker = new MapMaker();
    private final ReadOnlyStatus readOnly;
    private final int cancelTimeoutMs;
    private final Map<String, CmdCallbackPrx> callbacks = mapMaker.makeMap();
    private final AtomicReference<State> state = new AtomicReference();
    private final AtomicReference<Response> rsp = new AtomicReference();
    private final AtomicInteger currentStep = new AtomicInteger();
    private final Status status = new Status();
    private Map<String, String> callContext;
    private Principal principal;
    private Executor executor;
    private Identity id;
    private SessionI sess;
    private IRequest req;
    private Helper helper;

    @Deprecated
    public HandleI(int cancelTimeoutMs) {
        this(new ReadOnlyStatus(false, false), cancelTimeoutMs);
        LoggerFactory.getLogger(this.getClass()).info("assuming read-write repository");
    }

    public HandleI(ReadOnlyStatus readOnly, int cancelTimeoutMs) {
        this.readOnly = readOnly;
        this.cancelTimeoutMs = cancelTimeoutMs;
        this.state.set(State.CREATED);
    }

    @Override
    public void setSession(SessionI session) throws ServerError {
        this.sess = session;
        this.principal = this.sess.getPrincipal();
        this.executor = this.sess.getExecutor();
    }

    @Override
    public void initialize(Identity id, IRequest req, Map<String, String> ctx) {
        this.id = id;
        this.req = req;
        this.callContext = ctx;
        this.helper = new Helper((Request)((Object)req), this.status, null, null, null);
    }

    @Override
    public void addCallback(CmdCallbackPrx cb, Current __current) {
        Identity id = cb.ice_getIdentity();
        String key = Util.identityToString((Identity)id);
        this.helper.info("Add callback: %s", key);
        cb = CmdCallbackPrxHelper.checkedCast(cb.ice_oneway());
        this.callbacks.put(key, cb);
    }

    @Override
    public void removeCallback(CmdCallbackPrx cb, Current __current) {
        Identity id = cb.ice_getIdentity();
        String key = Util.identityToString((Identity)id);
        this.helper.info("Remove callback: %s", key);
        cb = CmdCallbackPrxHelper.checkedCast(cb.ice_oneway());
        this.callbacks.remove(key);
    }

    public void notifyCallbacks() {
        State state = this.state.get();
        boolean finished = state.equals((Object)State.FINISHED);
        boolean cancelled = state.equals((Object)State.CANCELLED);
        for (CmdCallbackPrx prx : this.callbacks.values()) {
            try {
                Response rsp = this.rsp.get();
                if (finished || cancelled) {
                    if (cancelled) {
                        this.helper.info("notify cancelled: %s/%s", new Object[]{rsp, this.status});
                    } else {
                        this.helper.info("notify finished: %s/%s", new Object[]{rsp, this.status});
                    }
                    prx.finished(rsp, this.status);
                    continue;
                }
                int step = this.currentStep.get();
                this.helper.info("notify step %s of %s", step, this.status.steps);
                prx.step(step, this.status.steps);
            }
            catch (Exception e) {
                this.sess.handleCallbackException(e);
            }
        }
    }

    @Override
    public Request getRequest(Current __current) {
        this.helper.info("getRequest: %s", this.req);
        return (Request)((Object)this.req);
    }

    @Override
    public Response getResponse(Current __current) {
        Response rsp = this.rsp.get();
        this.helper.info("getResponse: %s", new Object[]{rsp});
        return rsp;
    }

    @Override
    public Status getStatus(Current __current) {
        this.helper.info("getStatus: %s", new Object[]{this.status});
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(Current __current) throws LockTimeout {
        try {
            boolean cancelled = this.cancelWithoutNotification();
            if (cancelled) {
                try {
                    this.helper.cancel(new ERR(), null, "cancel-called", new String[0]);
                }
                catch (Cancel cancel) {
                    // empty catch block
                }
            }
            boolean bl = cancelled;
            return bl;
        }
        finally {
            this.notifyCallbacks();
        }
    }

    private boolean cancelWithoutNotification() throws LockTimeout {
        this.helper.info("Cancelling...", new Object[0]);
        if (this.state.compareAndSet(State.CREATED, State.CANCELLED) || this.state.compareAndSet(State.READY, State.CANCELLED)) {
            return true;
        }
        long start = System.currentTimeMillis();
        while ((long)this.cancelTimeoutMs >= System.currentTimeMillis() - start) {
            if (this.state.compareAndSet(State.RUNNING, State.CANCELLING) || this.state.compareAndSet(State.READY, State.CANCELLING) || this.state.compareAndSet(State.CANCELLING, State.CANCELLING)) {
                try {
                    Thread.sleep(this.cancelTimeoutMs / 10);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.state.compareAndSet(State.CANCELLED, State.CANCELLED)) {
                return true;
            }
            if (!this.state.compareAndSet(State.FINISHED, State.FINISHED)) continue;
            return false;
        }
        if (!this.state.compareAndSet(State.CANCELLING, State.RUNNING)) {
            this.helper.warn("Can't reset to RUNNING. State already changed.\nThis could be caused either by another thread having\nalready set the state back to RUNNING, or by the state\nhaving changed to CANCELLED. In either case, it is safe\nto throw the exception, and have the user recall cancel.", new Object[0]);
        }
        LockTimeout lt = new LockTimeout();
        lt.backOff = 5000L;
        lt.message = "timed out while waiting on CANCELLED state";
        lt.seconds = this.cancelTimeoutMs / 1000;
        throw lt;
    }

    @Override
    public void close(Current current) {
        this.sess.unregisterServant(this.id);
        try {
            this.closeWithoutNotification(current);
        }
        finally {
            this.notifyCallbacks();
        }
    }

    private void closeWithoutNotification(Current current) {
        this.helper.info("Closing...", new Object[0]);
        State s = this.state.get();
        if (!State.FINISHED.equals((Object)s) && !State.CANCELLED.equals((Object)s)) {
            this.helper.info("Handle closed before finished! State=" + (Object)((Object)this.state.get()), new Object[0]);
            try {
                this.cancel(current);
            }
            catch (LockTimeout e) {
                this.helper.warn("Cancel failed", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.state.compareAndSet(State.CREATED, State.READY)) {
            return;
        }
        Slf4JStopWatch sw = new Slf4JStopWatch();
        try {
            Map<String, String> merged = this.mergeContexts();
            List rv = this.req instanceof ReadOnlyStatus.IsAware && ((ReadOnlyStatus.IsAware)((Object)this.req)).isReadOnly(this.readOnly) ? (List)this.executor.execute(merged, this.principal, new RunSteps((Object)this, "run (ro)", new Object[]{Util.identityToString((Identity)this.id), this.req}){

                @Override
                @Transactional(readOnly=true)
                public List<Object> doWork(Session session, ServiceFactory sf) {
                    return this.innerWork(session, sf);
                }
            }) : (List)this.executor.execute(merged, this.principal, new RunSteps((Object)this, "run (rw)", new Object[]{Util.identityToString((Identity)this.id), this.req}){

                @Override
                @Transactional(readOnly=false)
                public List<Object> doWork(Session session, ServiceFactory sf) {
                    return this.innerWork(session, sf);
                }
            });
            for (int step = 0; step < this.status.steps; ++step) {
                Object obj = rv.get(step);
                this.req.buildResponse(step, obj);
            }
        }
        catch (Cancel cancel) {
            this.helper.debug("Request cancelled by %s", cancel.getCause());
        }
        catch (Throwable t) {
            this.helper.warn("Request rolled back by %s", t.getCause());
            this.helper.fail(new ERR(), t, "run-fail", new String[0]);
        }
        finally {
            this.rsp.set(this.req.getResponse());
            sw.stop("omero.request.tx");
            this.notifyCallbacks();
        }
    }

    private Map<String, String> mergeContexts() {
        HashMap<String, String> merged = new HashMap<String, String>();
        Map<String, String> reqCctx = this.req.getCallContext();
        if (this.callContext != null) {
            this.helper.debug("User callContext: %s", this.callContext);
            merged.putAll(this.callContext);
        }
        if (reqCctx != null) {
            this.helper.debug("Request callContext: %s", reqCctx);
            merged.putAll(reqCctx);
        }
        return merged;
    }

    public List<Object> steps(SqlAction sql, Session session, ServiceFactory sf) throws Cancel {
        Slf4JStopWatch swWhole = new Slf4JStopWatch();
        try {
            ArrayList<Object> rv = new ArrayList<Object>();
            Slf4JStopWatch swEach = null;
            this.helper = new Helper((Request)((Object)this.req), this.status, sql, session, sf);
            this.req.init(this.helper);
            int j = 0;
            while (j < this.status.steps) {
                swEach = new Slf4JStopWatch();
                try {
                    if (!this.state.compareAndSet(State.READY, State.RUNNING)) {
                        throw this.helper.cancel(new ERR(), null, "not-ready", new String[0]);
                    }
                    this.status.currentStep = j;
                    rv.add(this.req.step(j));
                }
                catch (Cancel c) {
                    throw c;
                }
                catch (Throwable t) {
                    throw this.helper.cancel(new ERR(), t, "bad-step", "step", "" + j);
                }
                finally {
                    swEach.stop("omero.request.step." + j);
                    this.state.compareAndSet(State.RUNNING, State.READY);
                }
                j = this.currentStep.incrementAndGet();
                int numOfCallbacks = 10;
                int mod = 1;
                if (this.status.steps > numOfCallbacks) {
                    mod = this.status.steps / numOfCallbacks;
                }
                if (j % mod != 0) continue;
                this.notifyCallbacks();
            }
            this.req.finish();
            ArrayList<Object> arrayList = rv;
            return arrayList;
        }
        catch (Cancel cancel) {
            throw cancel;
        }
        catch (Throwable t) {
            String msg = "Failure during Request.step:";
            this.helper.error(t, msg, new Object[0]);
            throw this.helper.cancel(new ERR(), t, "steps-cancel", new String[0]);
        }
        finally {
            swWhole.stop("omero.request");
            this.status.startTime = swWhole.getStartTime();
            this.status.stopTime = swWhole.getStartTime() + swWhole.getElapsedTime();
        }
    }

    public static class Cancel
    extends InternalException {
        private static final long serialVersionUID = 1L;

        public Cancel(String message) {
            super(message);
        }
    }

    private abstract class RunSteps
    extends Executor.SimpleWork {
        private RunSteps(Object string, String action, Object ... params) {
            super(string, action, params);
        }

        protected List<Object> innerWork(Session session, ServiceFactory sf) {
            try {
                List<Object> rv = HandleI.this.steps(this.getSqlAction(), session, sf);
                HandleI.this.state.set(State.FINISHED);
                return rv;
            }
            catch (Cancel c) {
                HandleI.this.state.set(State.CANCELLED);
                throw c;
            }
        }
    }

    private static enum State {
        CREATED,
        READY,
        RUNNING,
        CANCELLING,
        CANCELLED,
        FINISHED;

    }
}

