/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.model.ChannelData;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.GraphicsPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.PreviewCanvas;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.util.ViewedByItem;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButton;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.ColorListRenderer;
import org.openmicroscopy.shoola.util.ui.SeparatorPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableIconUtil;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

public class DomainPane
extends ControlPane
implements ActionListener,
ChangeListener,
MouseWheelListener {
    static int PREFERRED_DIVIDER_LOCATION = -1;
    static final int MIN_GAMMA = 1;
    static final int MAX_GAMMA = 40;
    static final int DEFAULT_GAMMA = 10;
    static final int MIN_BIT_DEPTH = 1;
    static final int MAX_BIT_DEPTH = 8;
    static final int DEFAULT_BIT_DEPTH = 8;
    private static final Border SELECTION_BORDER = BorderFactory.createLineBorder(Color.BLACK, 3);
    private static final int FACTOR = 10;
    private static final int FAMILY = 0;
    private static final int CHANNEL = 1;
    private static final Dimension VBOX = new Dimension(1, 10);
    private static final String ADVANCED_OPTIONS = "Advanced";
    private static final String Z_SLIDER_DESCRIPTION = "Select a z-section.";
    private static final String T_SLIDER_DESCRIPTION = "Select a timepoint.";
    private static final String LITEIME_SLIDER_DESCRIPTION = "Select a bin.";
    private static final String Z_SLIDER_TIPSTRING = "Z";
    private static final String T_SLIDER_TIPSTRING = "T";
    private static final String LIFETIME_SLIDER_TIPSTRING = "t";
    private static final String OPEN_BUTTON_TEXT = "Launch full viewer";
    private JComboBox familyBox;
    private List<ChannelButton> channelList;
    private OneKnobSlider gammaSlider;
    private OneKnobSlider bitDepthSlider;
    private JTextField gammaLabel;
    private JTextField bitDepthLabel;
    private JButton histogramButton;
    private GraphicsPane graphicsPane;
    private OneKnobSlider lifetimeSlider;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private PreviewCanvas canvas;
    private JComboBox channelsBox;
    private JButton openButton;

    private void initSlider(OneKnobSlider slider, int max, int v, String toolTip, String endLabel) {
        slider.setEnabled(max > 0);
        slider.setBackground(UIUtilities.BACKGROUND_COLOR);
        slider.setVisible(max != 0);
        slider.setMaximum(max);
        slider.setValue(v);
        slider.addChangeListener(this);
        slider.addMouseWheelListener(this);
        slider.setToolTipText(toolTip);
        slider.setEndLabel(endLabel);
        slider.setShowEndLabel(true);
        slider.setShowTipLabel(true);
        if (max > 0 && max <= 10) {
            slider.setPaintTicks(true);
            slider.setMajorTickSpacing(1);
        }
    }

    private void mouseWheelMovedZ(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxZ()) {
                    this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
            }
        }
        this.graphicsPane.setSelectedPlane();
    }

    private void mouseWheelMovedT(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultT() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxT()) {
                    this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
            }
        }
        this.graphicsPane.setSelectedPlane();
    }

    private void initComponents() {
        int maxBin;
        this.graphicsPane = new GraphicsPane(this.model, this.controller);
        this.familyBox = new JComboBox<Object>(this.model.getFamilies().toArray());
        this.familyBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        String family = this.model.getFamily();
        this.familyBox.setSelectedItem(family);
        this.familyBox.addActionListener(this);
        this.familyBox.setActionCommand("0");
        boolean gammaEnabled = family.equals("exponential") || family.equals("polynomial");
        double k = this.model.getCurveCoefficient();
        this.gammaSlider = new OneKnobSlider(0, 1, 40, (int)(k * 10.0));
        this.gammaSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gammaSlider.setShowArrows(false);
        this.gammaSlider.setEnabled(gammaEnabled);
        this.gammaSlider.addChangeListener(this);
        this.gammaSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                double v = (double)DomainPane.this.gammaSlider.getValue() / 10.0;
                DomainPane.this.gammaLabel.setText("" + v);
                int channel = DomainPane.this.channelsBox.getSelectedIndex();
                DomainPane.this.controller.setCurveCoefficient(channel, v);
            }
        });
        this.gammaLabel = new JTextField("" + k);
        this.gammaLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gammaLabel.setEnabled(gammaEnabled);
        this.gammaLabel.setEditable(true);
        this.gammaLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    double value = Double.parseDouble(DomainPane.this.gammaLabel.getText());
                    DomainPane.this.gammaSlider.setValue((int)(value * 10.0));
                    int channel = DomainPane.this.channelsBox.getSelectedIndex();
                    DomainPane.this.controller.setCurveCoefficient(channel, value);
                }
                catch (NumberFormatException e1) {
                    DomainPane.this.gammaLabel.setText("" + (double)DomainPane.this.gammaSlider.getValue() / 10.0);
                }
            }
        });
        int v = this.model.getBitResolution();
        this.bitDepthSlider = new OneKnobSlider(0, 1, 8, this.convertBitResolution(v));
        this.bitDepthSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.bitDepthSlider.setShowArrows(false);
        this.bitDepthSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int v = DomainPane.this.convertUIBitResolution(DomainPane.this.bitDepthSlider.getValue());
                DomainPane.this.bitDepthLabel.setText("" + v);
                DomainPane.this.firePropertyChange("bit_resolution", DomainPane.this.model.getBitResolution(), v);
            }
        });
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel = new JTextField("" + v);
        this.bitDepthLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.bitDepthLabel.setEnabled(false);
        this.bitDepthLabel.setEditable(false);
        this.histogramButton = new JButton(this.controller.getAction(RendererControl.HISTOGRAM));
        this.channelList = new ArrayList<ChannelButton>();
        if (this.model.isGeneralIndex()) {
            int maxZ = this.model.getMaxZ() - 1;
            this.zSlider = new OneKnobSlider(1, 0, 1, 0);
            this.zSlider.setEnabled(false);
            this.tSlider = new OneKnobSlider(0, 0, 1, 0);
            this.tSlider.setEnabled(false);
            this.initSlider(this.tSlider, this.model.getRealT() - 1, this.model.getRealSelectedT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
            this.initSlider(this.zSlider, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
            this.canvas = new PreviewCanvas();
            this.canvas.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.canvas.setInterpolate(Boolean.parseBoolean((String)MetadataViewerAgent.getRegistry().lookup("omero.client.viewer.interpolate_pixels")));
        }
        if (this.model.hasModuloT()) {
            this.lifetimeSlider = new OneKnobSlider(0, 0, 1, 0);
            this.lifetimeSlider.setEnabled(false);
            maxBin = this.model.getMaxLifetimeBin() - 1;
            this.initSlider(this.lifetimeSlider, maxBin, this.model.getSelectedBin(), LITEIME_SLIDER_DESCRIPTION, LIFETIME_SLIDER_TIPSTRING);
            this.lifetimeSlider.setPaintTicks(false);
        } else if (this.model.isLifetimeImage()) {
            this.lifetimeSlider = new OneKnobSlider(0, 0, 1, 0);
            this.lifetimeSlider.setEnabled(false);
            maxBin = this.model.getMaxLifetimeBin() - 1;
            this.initSlider(this.lifetimeSlider, maxBin, this.model.getSelectedBin(), LITEIME_SLIDER_DESCRIPTION, LIFETIME_SLIDER_TIPSTRING);
            this.lifetimeSlider.setPaintTicks(false);
        }
        this.graphicsPane.setSelectedPlane();
        this.channelsBox = new JComboBox();
        this.populateChannels();
        this.channelsBox.setRenderer(new ColorListRenderer());
        this.channelsBox.setActionCommand("1");
        this.channelsBox.setVisible(this.model.getMaxC() > 1);
        this.openButton = new JButton(this.controller.getAction(RendererControl.VIEW));
        this.openButton.setIcon(null);
        this.openButton.setText(OPEN_BUTTON_TEXT);
        this.openButton.setToolTipText(null);
    }

    private void populateChannels() {
        if (this.channelsBox == null) {
            return;
        }
        List<ChannelData> channels = this.model.getChannelData();
        Object[][] channelCols = new Object[channels.size()][2];
        Iterator<ChannelData> i = channels.iterator();
        int index = 0;
        int selected = 0;
        while (i.hasNext()) {
            ChannelData data = i.next();
            String lut = this.model.getLookupTable(data.getIndex());
            channelCols[index] = CommonsLangUtils.isNotEmpty(lut) ? new Object[]{lut, data.getChannelLabeling()} : new Object[]{this.model.getChannelColor(data.getIndex()), data.getChannelLabeling()};
            if (data.getIndex() == this.model.getSelectedChannel()) {
                selected = index;
            }
            ++index;
        }
        this.channelsBox.setModel(new DefaultComboBoxModel((E[])channelCols));
        this.channelsBox.removeActionListener(this);
        this.channelsBox.setSelectedIndex(selected);
        this.channelsBox.addActionListener(this);
    }

    private void resetBitResolution() {
        int v = this.model.getBitResolution();
        this.bitDepthSlider.removeChangeListener(this);
        this.bitDepthSlider.setValue(this.convertBitResolution(v));
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel.setText("" + v);
        this.bitDepthLabel.repaint();
    }

    private JComponent buildChannelGraphicsPanel() {
        JComponent result;
        if (this.model.isGeneralIndex()) {
            JPanel viewerPane = this.buildViewerPane();
            viewerPane.setBorder(BorderFactory.createLineBorder(UIUtilities.LIGHT_GREY, 1));
            this.graphicsPane.setBorder(BorderFactory.createLineBorder(UIUtilities.LIGHT_GREY, 1));
            final JSplitPane p = new JSplitPane(0);
            p.setTopComponent(viewerPane);
            p.setBottomComponent(this.graphicsPane);
            viewerPane.setMinimumSize(this.model.getPreviewDimension());
            if (PREFERRED_DIVIDER_LOCATION > 0) {
                p.setDividerLocation(PREFERRED_DIVIDER_LOCATION);
            }
            p.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    PREFERRED_DIVIDER_LOCATION = p.getDividerLocation();
                }
            });
            result = p;
        } else {
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            p.setBackground(UIUtilities.BACKGROUND_COLOR);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            p.add((Component)this.graphicsPane, c);
            ++c.gridy;
            c.weighty = 0.0;
            c.insets = new Insets(10, 0, 0, 0);
            c.fill = 2;
            p.add((Component)this.buildControlsPane(), c);
            result = new JScrollPane(p);
        }
        result.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        result.setBackground(UIUtilities.BACKGROUND_COLOR);
        return result;
    }

    private JPanel buildViewerPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        p.add((Component)this.openButton, c);
        ++c.gridy;
        c.fill = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        p.add((Component)this.zSlider, c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.canvas, c);
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        if (this.tSlider.isVisible()) {
            p.add((Component)this.tSlider, c);
            ++c.gridy;
        }
        if (this.lifetimeSlider != null) {
            p.add((Component)this.lifetimeSlider, c);
        }
        return p;
    }

    private void updateSlider(JSlider slider, int v) {
        slider.removeChangeListener(this);
        slider.setValue(v);
        slider.addChangeListener(this);
        this.graphicsPane.setSelectedPlane();
    }

    private JPanel buildSliderPane(JSlider slider, JTextField field) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(slider);
        p.add(field);
        return UIUtilities.buildComponentPanel(p);
    }

    private void addComponent(GridBagConstraints c, String l, JComponent comp, JPanel p) {
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        if (l != null && l.length() > 0) {
            p.add((Component)new JLabel(l), c);
            ++c.gridx;
            p.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
        }
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        p.add((Component)comp, c);
    }

    private JPanel buildControlsPane() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(ADVANCED_OPTIONS));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        JPanel comp = this.buildSliderPane(this.bitDepthSlider, this.bitDepthLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Brightness", this.graphicsPane.getCodomainSlider(), p);
        ++c.gridy;
        comp = this.buildSliderPane(this.bitDepthSlider, this.bitDepthLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Bit Depth", comp, p);
        c.gridx = 0;
        ++c.gridy;
        comp = new SeparatorPane();
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add((Component)comp, c);
        ++c.gridy;
        if (this.channelsBox.isVisible()) {
            comp = UIUtilities.buildComponentPanel(this.channelsBox);
            comp.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.addComponent(c, "Channel", comp, p);
            ++c.gridy;
        }
        comp = UIUtilities.buildComponentPanel(this.familyBox);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Map", comp, p);
        ++c.gridy;
        comp = this.buildSliderPane(this.gammaSlider, this.gammaLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Gamma", comp, p);
        return p;
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.buildChannelGraphicsPanel(), c);
    }

    private int convertUIBitResolution(int uiValue) {
        switch (uiValue) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 15;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 63;
            }
            case 7: {
                return 127;
            }
        }
        return 255;
    }

    private int convertBitResolution(int value) {
        switch (value) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 15: {
                return 4;
            }
            case 31: {
                return 5;
            }
            case 63: {
                return 6;
            }
            case 127: {
                return 7;
            }
        }
        return 8;
    }

    private void resetGamma(double k) {
        this.gammaSlider.removeChangeListener(this);
        this.gammaSlider.setValue((int)(k * 10.0));
        this.gammaSlider.addChangeListener(this);
        this.gammaLabel.setText("" + k);
    }

    private void mouseWheelMovedLifetime(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getRealSelectedT() - e.getWheelRotation();
            int bin = this.lifetimeSlider.getValue();
            if (up) {
                if (v <= this.model.getMaxLifetimeBin()) {
                    this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getRealSelectedT(), bin);
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getRealSelectedT(), bin);
            }
        }
    }

    @Override
    protected String getPaneName() {
        return "Mapping";
    }

    @Override
    protected Icon getPaneIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(66);
    }

    @Override
    protected String getPaneDescription() {
        return "Define the mapping context for the pixels intensity values.";
    }

    @Override
    protected int getPaneIndex() {
        return 0;
    }

    @Override
    protected void resetDefaultRndSettings() {
        this.setInputInterval();
        this.setInputRange(false);
        this.setSelectedChannel();
        this.setCodomainInterval();
        this.resetBitResolution();
        int n = this.model.getMaxC();
        for (int i = 0; i < n; ++i) {
            this.setChannelColor(i);
        }
        this.resetGamma(this.model.getCurveCoefficient());
        this.setZSection(this.model.getDefaultZ());
        this.setTimepoint(this.model.getDefaultT());
        this.setGreyScale(this.model.isGreyScale());
    }

    void resetViewedBy(RndProxyDef settings) {
        this.graphicsPane.resetViewedBy(settings);
    }

    @Override
    protected void onStateChange(boolean b) {
        if (this.familyBox != null) {
            this.familyBox.setEnabled(b);
        }
        if (this.gammaSlider != null) {
            String family = this.model.getFamily();
            boolean enabled = family.equals("exponential") || family.equals("polynomial");
            this.gammaSlider.setEnabled(enabled);
            this.gammaLabel.setEnabled(enabled);
        }
        if (this.bitDepthSlider != null) {
            this.bitDepthSlider.setEnabled(b);
        }
        if (this.channelList != null) {
            Iterator<ChannelButton> i = this.channelList.iterator();
            while (i.hasNext()) {
                i.next().setEnabled(b);
            }
        }
        this.graphicsPane.onStateChange(b);
    }

    @Override
    protected void switchRndControl() {
    }

    DomainPane(RendererModel model, RendererControl controller) {
        super(model, controller);
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedChannel() {
        this.graphicsPane.setSelectedChannel();
        Iterator<ChannelButton> i = this.channelList.iterator();
        List<Integer> active = this.model.getActiveChannels();
        if (active == null) {
            return;
        }
        int c = this.model.getSelectedChannel();
        while (i.hasNext()) {
            ChannelButton btn = i.next();
            int index = btn.getChannelIndex();
            btn.setSelected(active.contains(index));
            if (index == c && !this.model.isGeneralIndex()) {
                btn.setBorder(SELECTION_BORDER);
            }
            btn.setColor(this.model.getChannelColor(index));
        }
    }

    void setInputInterval() {
        this.graphicsPane.setInputInterval();
    }

    void setInputRange(boolean booleanValue) {
        this.graphicsPane.setInputRange(booleanValue);
    }

    void setCodomainInterval() {
        this.graphicsPane.setCodomainInterval();
    }

    void setChannelColor(int index) {
        for (ChannelButton btn : this.channelList) {
            if (index != btn.getChannelIndex()) continue;
            btn.setColor(this.model.getChannelColor(index));
        }
        this.graphicsPane.setChannelColor(index);
        if (this.channelsBox != null) {
            this.populateChannels();
        }
    }

    void setLookupTable(int index) {
        for (ChannelButton btn : this.channelList) {
            if (index != btn.getChannelIndex()) continue;
            btn.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(index)));
        }
        this.graphicsPane.setChannelColor(index);
        if (this.channelsBox != null) {
            this.populateChannels();
        }
    }

    void setColorModelChanged() {
        int selected = this.model.getSelectedChannel();
        for (int i = 0; i < this.channelList.size(); ++i) {
            ChannelButton btn = this.channelList.get(i);
            int index = btn.getChannelIndex();
            btn.setColor(this.model.getChannelColor(index));
            btn.setSelected(this.model.isChannelActive(index));
            if (index != selected || this.model.isGeneralIndex()) continue;
            btn.setBorder(SELECTION_BORDER);
        }
        this.graphicsPane.setColorModelChanged();
    }

    void onCurveChange() {
        String f = this.model.getFamily();
        boolean b = !f.equals("linear") && !f.equals("logarithmic");
        double k = 1.0;
        if (b) {
            k = this.model.getCurveCoefficient();
        }
        this.resetGamma(k);
        this.gammaSlider.setEnabled(b);
        this.gammaLabel.setEnabled(b);
        this.graphicsPane.onCurveChange();
    }

    void setTimepoint(int t) {
        if (this.tSlider != null) {
            this.updateSlider(this.tSlider, t);
        }
    }

    void setZSection(int z) {
        if (this.zSlider != null) {
            this.updateSlider(this.zSlider, z);
        }
    }

    void setGreyScale(boolean b) {
        this.graphicsPane.updateGreyScale(b);
    }

    boolean isSourceDisplayed(Object source) {
        Iterator<ChannelButton> i = this.channelList.iterator();
        while (i.hasNext()) {
            if (i.next() != source) continue;
            return true;
        }
        return false;
    }

    void renderPreview() {
        if (this.canvas == null) {
            return;
        }
        BufferedImage img = this.model.renderImage();
        this.canvas.setImage(img);
    }

    void displayViewedBy(List<ViewedByItem> results, RndProxyDef activeRndDef) {
        this.graphicsPane.displayViewedBy(results, activeRndDef);
    }

    void onChannelUpdated() {
        this.populateChannels();
        Iterator<ChannelButton> i = this.channelList.iterator();
        List<ChannelData> channels = this.model.getChannelData();
        while (i.hasNext()) {
            ChannelButton cb = i.next();
            ChannelData data = channels.get(cb.getChannelIndex());
            cb.setText(data.getChannelLabeling());
        }
    }

    void onHistogramLoaded(int ch) {
        this.graphicsPane.onHistogramLoaded(ch);
    }

    RndProxyDef getSelectedDef() {
        return this.graphicsPane.getSelectedDef();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.gammaSlider)) {
            this.gammaLabel.setText("" + (double)this.gammaSlider.getValue() / 10.0);
        } else if (source.equals(this.bitDepthSlider)) {
            this.bitDepthLabel.setText("" + this.convertUIBitResolution(this.bitDepthSlider.getValue()));
        } else if (source.equals(this.tSlider) || source.equals(this.zSlider)) {
            if (this.lifetimeSlider != null && this.lifetimeSlider.isVisible()) {
                this.controller.setSelectedXYPlane(this.zSlider.getValue(), this.tSlider.getValue(), this.lifetimeSlider.getValue());
            } else {
                this.controller.setSelectedXYPlane(this.zSlider.getValue(), this.tSlider.getValue());
            }
        } else if (source.equals(this.lifetimeSlider)) {
            this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getRealSelectedT(), this.lifetimeSlider.getValue());
            this.graphicsPane.setSelectedPlane();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = -1;
        index = Integer.parseInt(e.getActionCommand());
        int v = this.channelsBox.getSelectedIndex();
        try {
            switch (index) {
                case 0: {
                    String f = (String)((JComboBox)e.getSource()).getSelectedItem();
                    this.controller.setChannelFamily(v, f);
                    break;
                }
                case 1: {
                    String family = this.model.getFamily(v);
                    double coefficient = this.model.getCurveCoefficient(v);
                    this.familyBox.removeActionListener(this);
                    this.familyBox.setSelectedItem(family);
                    this.familyBox.addActionListener(this);
                    boolean enabled = family.equals("exponential") || family.equals("polynomial");
                    this.gammaSlider.removeChangeListener(this);
                    this.gammaSlider.setValue((int)(coefficient * 10.0));
                    this.gammaSlider.setEnabled(enabled);
                    this.gammaSlider.addChangeListener(this);
                    this.gammaLabel.setText("" + coefficient);
                    this.gammaLabel.setEnabled(enabled);
                    this.controller.setChannelSelection(v, true);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Object source = e.getSource();
        if (source == this.zSlider && this.zSlider.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSlider && this.tSlider.isEnabled()) {
            this.mouseWheelMovedT(e);
        } else if (source == this.lifetimeSlider && this.lifetimeSlider.isEnabled()) {
            this.mouseWheelMovedLifetime(e);
        }
    }
}

