/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.util.ui.ScriptComponent;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class RowPane
extends JPanel
implements ActionListener,
DocumentListener {
    static final String REMOVE_ROW_PROPERTY = "removeRow";
    static final String MODIFIED_CONTENT_PROPERTY = "modifiedContent";
    private JButton removeButton;
    private JComponent keyComponent;
    private JComponent valueComponent;

    private void initialize() {
        this.valueComponent = null;
        IconManager icons = IconManager.getInstance();
        this.removeButton = new JButton(icons.getIcon(52));
        this.removeButton.setToolTipText("Remove the row.");
        this.removeButton.addActionListener(this);
        UIUtilities.unifiedButtonLookAndFeel(this.removeButton);
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.removeButton);
        p.add(this.keyComponent);
        if (this.valueComponent != null) {
            p.add(Box.createHorizontalStrut(2));
            p.add(this.valueComponent);
        }
        this.setLayout(new FlowLayout(0));
        this.add(p);
    }

    private JComponent createKeyField(Class keyType) {
        JTextField field;
        if (Double.class.equals((Object)keyType) || Integer.class.equals((Object)keyType) || Long.class.equals((Object)keyType) || Float.class.equals((Object)keyType)) {
            field = new NumericalTextField();
            field.setNumberType(keyType);
        } else {
            field = new JTextField();
        }
        field.getDocument().addDocumentListener(this);
        field.setColumns(ScriptComponent.COLUMNS);
        return field;
    }

    RowPane(Class keyType) {
        this.initialize();
        this.keyComponent = this.createKeyField(keyType);
        this.buildGUI();
    }

    RowPane(Object[] values) {
        this(null, values);
    }

    RowPane(Class keyType, Class valueType) {
        this.initialize();
        this.keyComponent = this.createKeyField(keyType);
        if (valueType != null) {
            this.valueComponent = this.createKeyField(valueType);
        }
        this.buildGUI();
    }

    RowPane(Class keyType, Object[] values) {
        this.initialize();
        if (keyType == null) {
            this.keyComponent = new JComboBox<Object>(values);
        } else {
            this.keyComponent = this.createKeyField(keyType);
            this.valueComponent = new JComboBox<Object>(values);
        }
        this.buildGUI();
    }

    void setDefaultValue(int index) {
        JComboBox box;
        if (this.valueComponent instanceof JComboBox) {
            box = (JComboBox)this.valueComponent;
            box.setSelectedIndex(index);
        }
        if (this.keyComponent instanceof JComboBox) {
            box = (JComboBox)this.keyComponent;
            box.setSelectedIndex(index);
        }
    }

    Object getKeyResult() {
        return ScriptComponent.getComponentValue(this.keyComponent);
    }

    Object getValueResult() {
        return ScriptComponent.getComponentValue(this.valueComponent);
    }

    void disableRemove() {
        this.removeButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange(REMOVE_ROW_PROPERTY, null, this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange(MODIFIED_CONTENT_PROPERTY, null, this);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange(MODIFIED_CONTENT_PROPERTY, null, this);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.keyComponent != null) {
            this.keyComponent.setToolTipText(text);
        }
        if (this.valueComponent != null) {
            this.valueComponent.setToolTipText(text);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.removeButton != null) {
            this.removeButton.setEnabled(enabled);
        }
        if (this.keyComponent != null) {
            this.keyComponent.setEnabled(enabled);
        }
        if (this.valueComponent != null) {
            this.valueComponent.setEnabled(enabled);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

