/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parser {
    public static final String EXECUTABLE_PATH = "executablePath";
    public static final String EXECUTABLE_ICON = "executableIcon";
    public static final String EXECUTABLE_NAME = "executableName";
    private static final String EXECUTABLE_TAG_MAC = "CFBundleExecutable";
    private static final String ICON_TAG_MAC = "CFBundleIconFile";
    private static final String NAME_TAG_MAC = "CFBundleName";
    public static final String RESOURCES_MAC = "/Contents/Resources/";
    public static final String EXECUTABLE_MAC = "/Contents/MacOS/";
    private static final String INFO_FILE_MAC = "/Contents/Info.plist";

    public static Map<String, Object> parseInfoPList(String path) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = f.newDocumentBuilder();
        Document doc = builder.parse(new File(path + INFO_FILE_MAC));
        NodeList list = doc.getElementsByTagName("dict");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            NodeList nodes = node.getChildNodes();
            for (int j = 0; j < nodes.getLength(); ++j) {
                String r;
                Node s;
                Node child = nodes.item(j);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("key")) continue;
                String value = child.getTextContent().trim();
                if (EXECUTABLE_TAG_MAC.equals(value)) {
                    if (child.getNextSibling() == null) continue;
                    s = child.getNextSibling().getNextSibling();
                    r = path + EXECUTABLE_MAC + s.getTextContent().trim();
                    map.put(EXECUTABLE_PATH, r);
                    continue;
                }
                if (ICON_TAG_MAC.equals(value)) {
                    if (child.getNextSibling() == null) continue;
                    s = child.getNextSibling().getNextSibling();
                    r = path + RESOURCES_MAC + s.getTextContent().trim();
                    map.put(EXECUTABLE_ICON, r);
                    continue;
                }
                if (!NAME_TAG_MAC.equals(value) || child.getNextSibling() == null) continue;
                s = child.getNextSibling().getNextSibling();
                map.put(EXECUTABLE_NAME, s.getTextContent().trim());
            }
        }
        return map;
    }
}

