/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import omero.gateway.model.EllipseData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LineData;
import omero.gateway.model.MaskData;
import omero.gateway.model.PointData;
import omero.gateway.model.PolygonData;
import omero.gateway.model.PolylineData;
import omero.gateway.model.ROIData;
import omero.gateway.model.RectangleData;
import omero.gateway.model.ShapeData;
import omero.gateway.model.ShapeSettingsData;
import omero.gateway.model.TextData;
import omero.model.AffineTransform;
import omero.model.AffineTransformI;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import omero.rtypes;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.Cap;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureMaskFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class OutputServerStrategy {
    private ROIComponent component;
    private List<ROIData> ROIList;

    private void parseROI(ImageData image, int index, long userID) throws Exception {
        TreeMap<Long, ROI> map = this.component.getROIMap();
        Iterator<ROI> i = map.values().iterator();
        switch (index) {
            case 0: {
                while (i.hasNext()) {
                    ROI roi = i.next();
                    if (!roi.canAnnotate()) continue;
                    this.ROIList.add(this.createServerROI(roi, image));
                }
                break;
            }
            case 5: {
                while (i.hasNext()) {
                    ROI roi = i.next();
                    if (!roi.canEdit()) continue;
                    this.ROIList.add(this.createServerROI(roi, image));
                }
                break;
            }
            case 1: {
                while (i.hasNext()) {
                    ROI roi = i.next();
                    if (!roi.canDelete()) continue;
                    this.ROIList.add(this.createServerROI(roi, image));
                }
                break;
            }
            case 2: {
                while (i.hasNext()) {
                    ROI roi = i.next();
                    if (!roi.canDelete() || roi.getOwnerID() >= 0L && roi.getOwnerID() != userID) continue;
                    this.ROIList.add(this.createServerROI(roi, image));
                }
                break;
            }
            case 3: {
                while (i.hasNext()) {
                    ROI roi = i.next();
                    if (!roi.canDelete() || roi.getOwnerID() < 0L || roi.getOwnerID() == userID) continue;
                    this.ROIList.add(this.createServerROI(roi, image));
                }
                break;
            }
            case 4: {
                while (i.hasNext()) {
                    this.ROIList.add(this.createServerROI(i.next(), image));
                }
                break;
            }
        }
    }

    private ShapeData createShapeData(ROIShape clientShape) throws Exception {
        ROIFigure fig = clientShape.getFigure();
        ShapeData shape = null;
        if (fig instanceof MeasureBezierFigure) {
            shape = this.createBezierFigure(clientShape);
        } else if (fig instanceof MeasureEllipseFigure) {
            shape = this.createEllipseFigure(clientShape);
        } else if (fig instanceof MeasureLineFigure) {
            shape = this.createLineFigure(clientShape);
        } else if (fig instanceof MeasureMaskFigure) {
            shape = this.createMaskFigure(clientShape);
        } else if (fig instanceof MeasurePointFigure) {
            shape = this.createPointFigure(clientShape);
        } else if (fig instanceof MeasureRectangleFigure) {
            shape = this.createRectangleFigure(clientShape);
        } else if (fig instanceof MeasureTextFigure) {
            shape = this.createTextFigure(clientShape);
        }
        if (shape == null) {
            throw new Exception("ROIShape not supported : " + clientShape.getClass().toString());
        }
        if (clientShape.getT() >= 0) {
            shape.setT(clientShape.getT());
        }
        if (clientShape.getZ() >= 0) {
            shape.setZ(clientShape.getZ());
        }
        shape.setDirty(fig.isDirty());
        if (!fig.isClientObject()) {
            shape.setId(clientShape.getROIShapeID());
        }
        return shape;
    }

    private ROIData createServerROI(ROI roi, ImageData image) throws Exception {
        ROIData roiData = new ROIData();
        roiData.setUuid(roi.getUUID());
        roiData.setClientSide(roi.isClientSide());
        if (!roi.isClientSide()) {
            roiData.setId(roi.getID());
        }
        roiData.setImage(image.asImage());
        TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
        for (ROIShape roiShape : shapes.values()) {
            ShapeData shape = this.createShapeData(roiShape);
            this.addShapeAttributes(roiShape.getFigure(), shape);
            roiData.addShapeData(shape);
        }
        return roiData;
    }

    private ShapeData createBezierFigure(ROIShape shape) throws ParsingException {
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        if (fig.isClosed()) {
            return this.createPolygonFigure(shape);
        }
        return this.createPolylineFigure(shape);
    }

    private EllipseData createEllipseFigure(ROIShape shape) throws ParsingException {
        java.awt.geom.AffineTransform t;
        MeasureEllipseFigure fig = (MeasureEllipseFigure)shape.getFigure();
        double rx = fig.getEllipse().getWidth() / 2.0;
        double ry = fig.getEllipse().getHeight() / 2.0;
        double cx = fig.getEllipse().getCenterX();
        double cy = fig.getEllipse().getCenterY();
        EllipseData ellipse = new EllipseData(cx, cy, rx, ry);
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && !text.equals("")) {
            ellipse.setText(text);
        }
        if ((t = (java.awt.geom.AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig)) != null) {
            ellipse.setTransform(OutputServerStrategy.toTransform(t));
        }
        return ellipse;
    }

    private MaskData createMaskFigure(ROIShape shape) {
        return null;
    }

    private PointData createPointFigure(ROIShape shape) throws ParsingException {
        java.awt.geom.AffineTransform t;
        MeasurePointFigure fig = (MeasurePointFigure)shape.getFigure();
        double cx = fig.getCentre().getX();
        double cy = fig.getCentre().getY();
        PointData point = new PointData(cx, cy);
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && !text.equals("")) {
            point.setText(fig.getText());
        }
        if ((t = (java.awt.geom.AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig)) != null) {
            point.setTransform(OutputServerStrategy.toTransform(t));
        }
        return point;
    }

    private TextData createTextFigure(ROIShape shape) throws ParsingException {
        java.awt.geom.AffineTransform t;
        MeasureTextFigure fig = (MeasureTextFigure)shape.getFigure();
        double x = fig.getBounds().getX();
        double y = fig.getBounds().getY();
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && text.equals("")) {
            text = "";
        }
        TextData data = new TextData(text, x, y);
        data.setDirty(fig.isDirty());
        if (shape.getT() >= 0) {
            data.setT(shape.getT());
        }
        if (shape.getZ() >= 0) {
            data.setZ(shape.getZ());
        }
        if ((t = (java.awt.geom.AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig)) != null) {
            data.setTransform(OutputServerStrategy.toTransform(t));
        }
        if (!fig.isClientObject()) {
            data.setId(shape.getROIShapeID());
        }
        return data;
    }

    private RectangleData createRectangleFigure(ROIShape shape) throws ParsingException {
        java.awt.geom.AffineTransform t;
        MeasureRectangleFigure fig = (MeasureRectangleFigure)shape.getFigure();
        double x = fig.getX();
        double y = fig.getY();
        double width = fig.getWidth();
        double height = fig.getHeight();
        RectangleData rectangle = new RectangleData(x, y, width, height);
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && !text.equals("")) {
            rectangle.setText(fig.getText());
        }
        if ((t = (java.awt.geom.AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig)) != null) {
            rectangle.setTransform(OutputServerStrategy.toTransform(t));
        }
        return rectangle;
    }

    private PolygonData createPolygonFigure(ROIShape shape) throws ParsingException {
        String text;
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        java.awt.geom.AffineTransform t = (java.awt.geom.AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
        }
        PolygonData poly = new PolygonData();
        poly.setPoints(points);
        if (t != null) {
            poly.setTransform(OutputServerStrategy.toTransform(t));
        }
        if ((text = fig.getText()) != null && text.trim().length() > 0 && !text.equals("")) {
            poly.setText(fig.getText());
        }
        return poly;
    }

    private ShapeData createLineFigure(ROIShape shape) throws ParsingException {
        String text;
        MeasureLineFigure fig = (MeasureLineFigure)shape.getFigure();
        BezierPath bezier = fig.getBezierPath();
        java.awt.geom.AffineTransform t = (java.awt.geom.AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        int n = bezier.size();
        if (n == 2) {
            String text2;
            BezierPath.Node start = (BezierPath.Node)bezier.get(0);
            BezierPath.Node end = (BezierPath.Node)bezier.get(1);
            LineData line = new LineData(start.x[0], start.y[0], end.x[0], end.y[0]);
            if (t != null) {
                line.setTransform(OutputServerStrategy.toTransform(t));
            }
            if ((text2 = fig.getText()) != null && text2.trim().length() > 0 && !text2.equals("")) {
                line.setText(fig.getText());
            }
            return line;
        }
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
        }
        PolylineData line = new PolylineData();
        line.setPoints(points);
        if (t != null) {
            line.setTransform(OutputServerStrategy.toTransform(t));
        }
        if ((text = fig.getText()) != null && text.trim().length() > 0 && !text.equals("")) {
            line.setText(fig.getText());
        }
        return line;
    }

    private PolylineData createPolylineFigure(ROIShape shape) throws ParsingException {
        String text;
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        java.awt.geom.AffineTransform t = (java.awt.geom.AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
        }
        PolylineData poly = new PolylineData();
        poly.setPoints(points);
        if (t != null) {
            poly.setTransform(OutputServerStrategy.toTransform(t));
        }
        if ((text = fig.getText()) != null && text.trim().length() > 0 && !text.equals("")) {
            poly.setText(fig.getText());
        }
        return poly;
    }

    private void addShapeAttributes(ROIFigure fig, ShapeData shape) {
        ShapeSettingsData settings = shape.getShapeSettings();
        Coord3D coord = fig.getROIShape().getCoord3D();
        int channel = coord.getChannel();
        if (channel >= 0) {
            shape.setC(channel);
        }
        if (AttributeKeys.FILL_COLOR.get((Figure)fig) != null) {
            Color c = (Color)AttributeKeys.FILL_COLOR.get((Figure)fig);
            settings.setFill(c);
        }
        if (MeasurementAttributes.STROKE_COLOR.get((Figure)fig) != null) {
            settings.setStroke((Color)MeasurementAttributes.STROKE_COLOR.get((Figure)fig));
        }
        if (MeasurementAttributes.STROKE_WIDTH.get((Figure)fig) != null) {
            settings.setStrokeWidth((Length)new LengthI(((Double)MeasurementAttributes.STROKE_WIDTH.get((Figure)fig)).doubleValue(), UnitsLength.PIXEL));
        }
        if (MeasurementAttributes.FONT_FACE.get((Figure)fig) != null) {
            settings.setFontFamily(UIUtilities.convertFont(((Font)MeasurementAttributes.FONT_FACE.get((Figure)fig)).getName()));
        } else {
            settings.setFontFamily("sans-serif");
        }
        if (MeasurementAttributes.FONT_SIZE.get((Figure)fig) != null) {
            settings.setFontSize((Length)new LengthI(((Double)MeasurementAttributes.FONT_SIZE.get((Figure)fig)).doubleValue(), UnitsLength.POINT));
        } else {
            settings.setFontSize((Length)new LengthI(12.0, UnitsLength.POINT));
        }
        Boolean bold = (Boolean)MeasurementAttributes.FONT_BOLD.get((Figure)fig);
        Boolean italic = (Boolean)MeasurementAttributes.FONT_ITALIC.get((Figure)fig);
        if (bold != null) {
            if (bold.booleanValue()) {
                if (italic != null && italic.booleanValue()) {
                    settings.setFontStyle("BoldItalic");
                } else {
                    settings.setFontStyle("Bold");
                }
            } else if (italic != null && italic.booleanValue()) {
                settings.setFontStyle("Italic");
            } else {
                settings.setFontStyle("Normal");
            }
        } else if (italic != null) {
            if (italic.booleanValue()) {
                if (bold != null && bold.booleanValue()) {
                    settings.setFontStyle("BoldItalic");
                } else {
                    settings.setFontStyle("Italic");
                }
            } else if (bold != null && bold.booleanValue()) {
                settings.setFontStyle("Bold");
            } else {
                settings.setFontStyle("Normal");
            }
        } else {
            settings.setFontStyle("Normal");
        }
        LineDecoration ld = (LineDecoration)MeasurementAttributes.START_DECORATION.get((Figure)fig);
        Cap c = Cap.findByPrototype(ld);
        if (c != null) {
            settings.setMarkerStart(c.getValue());
        } else {
            settings.setMarkerStart("");
        }
        ld = (LineDecoration)MeasurementAttributes.END_DECORATION.get((Figure)fig);
        c = Cap.findByPrototype(ld);
        if (c != null) {
            settings.setMarkerEnd(c.getValue());
        } else {
            settings.setMarkerEnd("");
        }
    }

    private static AffineTransform toTransform(java.awt.geom.AffineTransform awtTransform) {
        if (awtTransform.getType() == 0) {
            return null;
        }
        AffineTransformI omeroTransform = new AffineTransformI();
        omeroTransform.setA00(rtypes.rdouble((double)awtTransform.getScaleX()));
        omeroTransform.setA01(rtypes.rdouble((double)awtTransform.getShearX()));
        omeroTransform.setA02(rtypes.rdouble((double)awtTransform.getTranslateX()));
        omeroTransform.setA10(rtypes.rdouble((double)awtTransform.getShearY()));
        omeroTransform.setA11(rtypes.rdouble((double)awtTransform.getScaleY()));
        omeroTransform.setA12(rtypes.rdouble((double)awtTransform.getTranslateY()));
        return omeroTransform;
    }

    private static String toNumber(double number) {
        String str = Double.toString(number);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    OutputServerStrategy() {
    }

    List<ROIData> writeROI(ROIComponent component, ImageData image, int index, long userID) throws Exception {
        this.component = component;
        this.ROIList = new ArrayList<ROIData>();
        this.parseROI(image, index, userID);
        return this.ROIList;
    }
}

