/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.swingx.JXBusyLabel;

public class RotationIcon
implements Icon {
    private static final double DEFAULT_ANGLE = 90.0;
    private Icon icon;
    private final Timer timer;
    private double angle;

    public RotationIcon(JComponent component) {
        this(null, component, false);
    }

    public RotationIcon(Icon icon, final JComponent component, boolean start) {
        if (icon == null) {
            JXBusyLabel label = new JXBusyLabel();
            if (start) {
                label.setBusy(true);
            }
            label.setSize(16, 16);
            icon = label.getIcon();
        }
        this.icon = icon;
        this.angle = 90.0;
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RotationIcon.this.angle += 10.0;
                if (RotationIcon.this.angle == 360.0) {
                    RotationIcon.this.angle = 0.0;
                }
                component.repaint();
            }
        });
        this.timer.setRepeats(false);
        if (start) {
            this.timer.start();
        }
    }

    public void stopRotation() {
        this.timer.stop();
    }

    public void startRotation() {
        this.timer.start();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.stopRotation();
        Graphics2D g2 = (Graphics2D)g.create();
        int w = this.icon.getIconWidth() / 2;
        int h = this.icon.getIconHeight() / 2;
        Rectangle r = new Rectangle(x, y, this.getIconWidth(), this.getIconHeight());
        g2.setClip(r);
        AffineTransform original = g2.getTransform();
        AffineTransform at = new AffineTransform();
        at.concatenate(original);
        at.rotate(Math.toRadians(this.angle), x + w, y + h);
        g2.setTransform(at);
        this.icon.paintIcon(c, g2, x, y);
        g2.setTransform(original);
        this.startRotation();
    }
}

