/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import java.util.ArrayList;
import java.util.List;
import ome.model.meta.Session;
import ome.services.sessions.SessionProvider;
import ome.services.util.ReadOnlyStatus;
import ome.system.ServiceFactory;
import org.springframework.beans.factory.BeanCreationException;

public class SessionProviderWrapper<P extends SessionProvider & ReadOnlyStatus.IsAware>
implements SessionProvider {
    private final List<P> read;
    private final List<P> write;

    public SessionProviderWrapper(ReadOnlyStatus readOnly, List<P> providers) {
        this.read = providers;
        this.write = new ArrayList<P>(this.read.size());
        for (SessionProvider provider : this.read) {
            if (((ReadOnlyStatus.IsAware)((Object)provider)).isReadOnly(readOnly)) continue;
            this.write.add(provider);
        }
        if (this.write.isEmpty()) {
            throw new BeanCreationException("must be given a read-write session provider");
        }
    }

    @Override
    public Session executeUpdate(ServiceFactory sf, Session session, String uuid, long userId, Long sudoerId) {
        for (SessionProvider provider : this.read) {
            if (provider.findSessionIdByUuid(uuid, sf) == null) continue;
            return provider.executeUpdate(sf, session, uuid, userId, sudoerId);
        }
        return ((SessionProvider)this.write.get(0)).executeUpdate(sf, session, uuid, userId, sudoerId);
    }

    @Override
    public void executeCloseSession(String uuid) {
        for (SessionProvider provider : this.read) {
            if (provider.findSessionIdByUuid(uuid) == null) continue;
            provider.executeCloseSession(uuid);
        }
    }

    @Override
    public Session executeInternalSession(String uuid, Session session) {
        return ((SessionProvider)this.write.get(0)).executeInternalSession(uuid, session);
    }

    @Override
    public long executeNextSessionId() {
        return ((SessionProvider)this.write.get(0)).executeNextSessionId();
    }

    @Override
    public Session findSessionById(long id, org.hibernate.Session hibernateSession) {
        for (SessionProvider provider : this.read) {
            Session session = provider.findSessionById(id, hibernateSession);
            if (session == null) continue;
            return session;
        }
        return null;
    }

    @Override
    public Session findSessionById(long id, ServiceFactory sf) {
        for (SessionProvider provider : this.read) {
            Session session = provider.findSessionById(id, sf);
            if (session == null) continue;
            return session;
        }
        return null;
    }

    @Override
    public Long findSessionIdByUuid(String uuid, ServiceFactory sf) {
        for (SessionProvider provider : this.read) {
            Long sessionId = provider.findSessionIdByUuid(uuid, sf);
            if (sessionId == null) continue;
            return sessionId;
        }
        return null;
    }

    @Override
    public Long findSessionIdByUuid(String uuid) {
        for (SessionProvider provider : this.read) {
            Long sessionId = provider.findSessionIdByUuid(uuid);
            if (sessionId == null) continue;
            return sessionId;
        }
        return null;
    }
}

