/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.PreferenceContext;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

abstract class BaseDBCheck {
    private static final Logger log = LoggerFactory.getLogger(BaseDBCheck.class);
    protected final Executor executor;
    private final String version;
    private final int patch;
    private final String configKey;
    private final String configValue;
    private final String configKeyValue;
    private final boolean isReadOnlyDb;

    protected BaseDBCheck(Executor executor, PreferenceContext preferences, ReadOnlyStatus readOnly) {
        this.executor = executor;
        this.version = preferences.getProperty("omero.db.version");
        this.patch = Integer.parseInt(preferences.getProperty("omero.db.patch"));
        this.configKey = "DB check " + this.getClass().getSimpleName();
        this.configValue = this.getCheckDone();
        this.configKeyValue = this.configKey + ": " + this.configValue;
        this.isReadOnlyDb = readOnly.isReadOnlyDb();
    }

    private boolean isCheckRequired() {
        return (Boolean)this.executor.executeSql(new Executor.SimpleSqlWork(this, "BaseDBCheck", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Boolean doWork(SqlAction sql) {
                return !BaseDBCheck.this.configValue.equals(sql.configValue(BaseDBCheck.this.configKey));
            }
        });
    }

    private void checkIsStarting() {
        this.executor.executeSql(new Executor.SimpleSqlWork(this, "BaseDBCheck", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                sql.addMessageWithinDbPatchStart(BaseDBCheck.this.version, BaseDBCheck.this.patch, BaseDBCheck.this.configKeyValue);
                return null;
            }
        });
    }

    private void checkIsDone() {
        this.executor.executeSql(new Executor.SimpleSqlWork(this, "BaseDBCheck", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                sql.addMessageWithinDbPatchEnd(BaseDBCheck.this.version, BaseDBCheck.this.patch, BaseDBCheck.this.configKeyValue);
                sql.updateOrInsertConfigValue(BaseDBCheck.this.configKey, BaseDBCheck.this.configValue);
                return null;
            }
        });
    }

    public void start() {
        if (this.isCheckRequired()) {
            if (this.isReadOnlyDb) {
                this.doCheck();
            } else {
                this.checkIsStarting();
                this.doCheck();
                this.checkIsDone();
            }
            log.info("performed " + this.configKeyValue);
        } else if (log.isDebugEnabled()) {
            log.debug("skipped " + this.configKey);
        }
    }

    protected abstract void doCheck();

    protected String getCheckDone() {
        return "done";
    }

    protected String getOmeroVersion() {
        return this.version + "__" + this.patch;
    }
}

