/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class CommonViewer
extends JPanel {
    private ModuleContent content;
    private boolean inputEvent;
    private JPanel tagPane;
    private boolean labelVisible;

    public CommonViewer() {
        this((ModuleContent)null, true);
    }

    public CommonViewer(ModuleContent c) {
        this(c, true);
    }

    public CommonViewer(ModuleContent c, boolean labelVisible) {
        this.content = c;
        this.inputEvent = false;
        this.labelVisible = labelVisible;
        this.showModule();
        this.revalidate();
        this.repaint();
    }

    private void showModule() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (this.content != null && this.content.getTagList() != null) {
            this.layoutComponents();
            this.buildGUI();
        }
    }

    public LinkedHashMap<String, TagData> getTagList() {
        if (this.content != null) {
            return this.content.getList();
        }
        return null;
    }

    private void layoutComponents() {
        this.tagPane = new JPanel();
        this.tagPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.tagPane, "Center");
    }

    private void buildGUI() {
        ArrayList<JComponent> labels = new ArrayList<JComponent>();
        ArrayList<JComponent> comp = new ArrayList<JComponent>();
        for (TagData t : this.content.getTagList()) {
            this.addTagToGUI(t, labels, comp);
        }
        if (this.labelVisible) {
            CommonViewer.addLabelTextRows(labels, comp, this.tagPane);
        } else {
            CommonViewer.addLabelTextRows(null, comp, this.tagPane);
        }
    }

    private void addTagToGUI(TagData tag, List<JComponent> labels, List<JComponent> comp) {
        if (tag != null && tag.isVisible()) {
            labels.add(tag.getTagLabelAndUnit());
            comp.add(tag.getInputField());
        }
    }

    public static void addLabelTextRows(List<JComponent> labels, List<JComponent> fields, Container container) {
        block4: {
            GridBagConstraints c;
            block5: {
                block3: {
                    GridBagLayout gridbag = new GridBagLayout();
                    container.setLayout(gridbag);
                    c = new GridBagConstraints();
                    c.anchor = 18;
                    if (labels == null || fields == null) break block3;
                    int numLabels = labels.size();
                    c.insets = new Insets(0, 1, 1, 0);
                    for (int i = 0; i < numLabels; ++i) {
                        c.gridwidth = -1;
                        c.fill = 2;
                        c.weightx = 0.0;
                        container.add((Component)labels.get(i), c);
                        c.gridwidth = 0;
                        c.fill = 2;
                        c.weightx = 1.0;
                        container.add((Component)fields.get(i), c);
                    }
                    break block4;
                }
                if (fields == null) break block5;
                int numElem = fields.size();
                c.insets = new Insets(0, 0, 1, 0);
                for (int i = 0; i < numElem; ++i) {
                    c.gridwidth = 1;
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.gridx = 0;
                    c.gridy = i;
                    container.add((Component)fields.get(i), c);
                }
                break block4;
            }
            if (labels == null) break block4;
            int numElem = labels.size();
            c.insets = new Insets(0, 0, 1, 0);
            for (int i = 0; i < numElem; ++i) {
                c.gridwidth = 0;
                c.fill = 2;
                c.weightx = 1.0;
                container.add((Component)labels.get(i), c);
            }
        }
    }

    public LinkedHashMap<String, TagData> getChangedTags() {
        if (this.content == null) {
            return null;
        }
        LinkedHashMap<String, TagData> list = new LinkedHashMap<String, TagData>();
        for (TagData t : this.content.getTagList()) {
            if (!t.valueHasChanged()) continue;
            list.put(t.getTagName(), t);
        }
        return list;
    }

    public void afterSavingData() {
        if (this.content == null) {
            return;
        }
        for (TagData t : this.content.getTagList()) {
            if (t == null) continue;
            t.dataSaved(true);
        }
    }
}

