/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ChannelMovieAction
extends ViewerAction
implements PropertyChangeListener {
    private static final String DESCRIPTION = "Play movie across channels.";
    private IconManager icons = IconManager.getInstance();
    private boolean play;

    @Override
    protected void onStateChange(ChangeEvent e) {
        int state = this.model.getState();
        switch (state) {
            case 1: 
            case 7: {
                this.setEnabled(false);
                return;
            }
            case 8: {
                this.setEnabled(!this.model.isBigImage());
                return;
            }
        }
        if (this.model.isBigImage()) {
            this.setEnabled(false);
            return;
        }
        if (this.play) {
            if (this.model.getActiveChannels().size() > 1) {
                this.setEnabled(true);
            }
        } else if (state == 6) {
            this.setEnabled(this.model.getActiveChannels().size() > 1);
        }
    }

    public ChannelMovieAction(ImViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", this.icons.getIcon(15));
        model.addPropertyChangeListener("channelActive", this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Icon icon = (Icon)this.getValue("SmallIcon");
        this.play = false;
        if (icon.toString().equals(this.icons.getIcon(15).toString())) {
            this.putValue("SmallIcon", this.icons.getIcon(17));
            this.play = true;
        } else {
            this.putValue("SmallIcon", this.icons.getIcon(15));
        }
        this.model.playChannelMovie(this.play);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("channelActive") && !this.play && this.model.getState() == 6) {
            this.setEnabled(this.model.getActiveChannels().size() > 1);
        }
    }
}

