/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ExpandableTextPane
extends JTextPane {
    public static final int DEFAULT_LINES = 3;
    private static final String LINEBREAK = "<(b|B|h|H)(r|R)/?>";
    private int showLines = 3;
    private String text = "";
    private boolean expanded = false;
    private boolean showMoreLink = true;

    public ExpandableTextPane() {
        this(3, true);
    }

    public ExpandableTextPane(boolean showMoreLink) {
        this(3, showMoreLink);
    }

    public ExpandableTextPane(int showLines) {
        this(showLines, true);
    }

    public ExpandableTextPane(int showLines, boolean showMoreLink) {
        this.setContentType("text/html");
        this.setEditable(false);
        this.showLines = showLines;
        this.showMoreLink = showMoreLink;
        if (showMoreLink) {
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ExpandableTextPane.this.setExpanded(!ExpandableTextPane.this.isExpanded());
                    }
                }
            });
        }
    }

    @Override
    public void setText(String t) {
        this.text = t.replaceAll("<(H|h)(T|t)(M|m)(L|l)/?>", "");
        if (this.expanded || this.getLineCount() < this.showLines) {
            super.setText(this.getSubstring(Integer.MAX_VALUE));
        } else {
            super.setText(this.getSubstring(this.showLines));
        }
    }

    public void setExpanded(boolean b) {
        this.expanded = b;
        if (this.expanded) {
            super.setText(this.getSubstring(Integer.MAX_VALUE));
        } else {
            super.setText(this.getSubstring(this.showLines));
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isExpandable() {
        return this.getLineCount() >= this.showLines;
    }

    private int getLineCount() {
        if (this.text.trim().length() == 0) {
            return 0;
        }
        return this.text.split(LINEBREAK).length;
    }

    private String getSubstring(int nLines) {
        int i;
        String[] lines = this.text.split(LINEBREAK);
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        for (i = 0; i < nLines && i < lines.length; ++i) {
            result.append(lines[i]);
            result.append("<br/>");
        }
        if (i < lines.length) {
            if (this.showMoreLink) {
                result.append("<a href=\"/\">Show more...</a>");
            } else {
                result.append("...");
            }
        } else if (this.showMoreLink && this.isExpanded()) {
            result.append("<a href=\"/\">Show less...</a>");
        }
        result.append("</html>");
        return result.toString();
    }
}

