/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellSampleData;
import omero.model.NamedValue;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerComponent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class MetadataViewerFactory
implements ChangeListener {
    private static final MetadataViewerFactory singleton = new MetadataViewerFactory();
    private static ImageData copyRenderingSettingsFrom;
    private static RndProxyDef copiedRndSettings;
    private static List<NamedValue> copiedMapAnnotationsEntries;
    private List<MetadataViewer> viewers = new ArrayList<MetadataViewer>();

    public static MetadataViewer getViewer(List<Object> data, Class type) {
        if (CollectionUtils.isEmpty(data)) {
            throw new IllegalArgumentException("No data to edit");
        }
        MetadataViewerModel model = new MetadataViewerModel(data, 0, null, -1L);
        model.setDataType(type);
        return singleton.createViewer(model);
    }

    public static MetadataViewer getViewer(Object refObject) {
        return MetadataViewerFactory.getViewer(refObject, 0, null, -1L);
    }

    public static MetadataViewer getViewer(Object refObject, int index, RndProxyDef def, long selectedViewedByDef) {
        MetadataViewerModel model = new MetadataViewerModel(refObject, index, def, selectedViewedByDef);
        return singleton.createViewer(model);
    }

    public static MetadataViewer getViewerFromId(String objectType, long id) {
        for (MetadataViewerComponent metadataViewerComponent : MetadataViewerFactory.singleton.viewers) {
            Object ref = metadataViewerComponent.getRefObject();
            String name = ref.getClass().getName();
            if (ref instanceof WellSampleData) {
                name = ImageData.class.getName();
            }
            if (!name.equals(objectType) || !(ref instanceof DataObject)) continue;
            long refId = ((DataObject)ref).getId();
            if (ref instanceof WellSampleData) {
                refId = ((WellSampleData)ref).getImage().getId();
            }
            if (id != refId) continue;
            return metadataViewerComponent;
        }
        return null;
    }

    public static List<Object> getInstancesToSave() {
        if (MetadataViewerFactory.singleton.viewers.size() == 0) {
            return null;
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        for (MetadataViewerComponent metadataViewerComponent : MetadataViewerFactory.singleton.viewers) {
            if (!metadataViewerComponent.hasDataToSave()) continue;
            instances.add(metadataViewerComponent);
        }
        return instances;
    }

    public static void setDiplayMode(int displayMode) {
        for (MetadataViewerComponent metadataViewerComponent : MetadataViewerFactory.singleton.viewers) {
            metadataViewerComponent.setDisplayMode(displayMode);
        }
    }

    public static void saveInstances(List<Object> instances) {
        if (instances != null) {
            for (Object o : instances) {
                if (!(o instanceof MetadataViewerComponent)) continue;
                ((MetadataViewerComponent)o).saveBeforeClose();
            }
        }
    }

    public static void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        singleton.clear();
    }

    private MetadataViewerFactory() {
    }

    private void clear() {
        for (MetadataViewer v : MetadataViewerFactory.singleton.viewers) {
            v.removeChangeListener(this);
            v.discard();
        }
        MetadataViewerFactory.singleton.viewers.clear();
    }

    private MetadataViewer createViewer(MetadataViewerModel model) {
        MetadataViewerComponent comp = new MetadataViewerComponent(model);
        model.initialize(comp);
        comp.initialize();
        comp.addChangeListener(this);
        this.viewers.add(comp);
        return comp;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MetadataViewerComponent comp = (MetadataViewerComponent)e.getSource();
        if (comp.getState() == 4 && this.viewers.size() > 0) {
            this.viewers.remove(comp);
        }
    }

    public static void applyCopiedRndSettings(long imageId) {
        for (MetadataViewer viewer : MetadataViewerFactory.singleton.viewers) {
            ImageData img;
            Object obj = viewer.getRefObject();
            if (obj instanceof ImageData && (img = (ImageData)obj).getId() == imageId) {
                viewer.applyCopiedRndSettings();
            }
            if (!(obj instanceof WellSampleData) || (img = ((WellSampleData)obj).getImage()).getId() != imageId) continue;
            viewer.applyCopiedRndSettings();
        }
    }

    public static boolean hasRndSettingsCopied(long imageId) {
        for (MetadataViewer viewer : MetadataViewerFactory.singleton.viewers) {
            ImageData img;
            Object obj = viewer.getRefObject();
            if (!(obj instanceof ImageData ? (img = (ImageData)obj).getId() == imageId : obj instanceof WellSampleData && (img = ((WellSampleData)obj).getImage()).getId() == imageId)) continue;
            return viewer.hasRndSettingsCopied();
        }
        return false;
    }

    public static ImageData getCopyRenderingSettingsFrom() {
        return copyRenderingSettingsFrom;
    }

    public static void setCopyRenderingSettingsFrom(ImageData copyRenderingSettingsFrom, RndProxyDef copiedRndSettings) {
        MetadataViewerFactory.copyRenderingSettingsFrom = copyRenderingSettingsFrom;
        MetadataViewerFactory.copiedRndSettings = copiedRndSettings;
    }

    public static RndProxyDef getCopiedRndSettings() {
        return copiedRndSettings;
    }

    public static List<NamedValue> getCopiedMapAnnotationsEntries() {
        return copiedMapAnnotationsEntries;
    }

    static {
        copiedMapAnnotationsEntries = new ArrayList<NamedValue>();
    }
}

