/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultTreeModel;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheck;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;

public class AddExistingObjectsDialog
extends JDialog {
    public static final String EXISTING_ADD_PROPERTY = "existingAdd";
    public static final String CLOSE_PROPERTY = "close";
    private static final String TITLE = "Add existing items";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private static final String TEXT = "Select items";
    private static final String NOTE = "Select the existing items to add to the current node";
    private static final String EMPTY_NOTE = "No existing objects.";
    private JButton finishButton;
    private JButton cancelButton;
    private JButton selectAllButton;
    private JButton deselectAllButton;
    private TreeCheck tree;
    private ViewerSorter sorter;

    private void setWinProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
    }

    private void finish() {
        Set nodes = this.tree.getSelectedNodes();
        if (nodes == null || nodes.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(TITLE, "No item selected.");
            return;
        }
        HashSet<Object> paths = new HashSet<Object>();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Object object = ((TreeCheckNode)i.next()).getUserObject();
            if (!(object instanceof DataObject)) continue;
            paths.add(object);
        }
        this.firePropertyChange(EXISTING_ADD_PROPERTY, null, paths);
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.sorter = new ViewerSorter();
        IconManager icons = IconManager.getInstance();
        this.tree = new TreeCheck("", icons.getIcon(7));
        this.selectAllButton = new JButton("Select All");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExistingObjectsDialog.this.tree.selectAllNodes();
            }
        });
        this.deselectAllButton = new JButton("Deselect All");
        this.deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExistingObjectsDialog.this.tree.deselectAllNodes();
            }
        });
        this.finishButton = new JButton("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExistingObjectsDialog.this.finish();
            }
        });
        this.cancelButton = new JButton("Close");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExistingObjectsDialog.this.close();
            }
        });
    }

    private void buildTreeNode(TreeCheckNode parent, List nodes) {
        DefaultTreeModel tm = (DefaultTreeModel)this.tree.getModel();
        for (TreeCheckNode display : nodes) {
            tm.insertNodeInto(display, parent, parent.getChildCount());
            Set children = display.getChildrenDisplay();
            if (children.size() == 0) continue;
            this.buildTreeNode(display, this.sorter.sort(children));
        }
    }

    private JToolBar buildRightToolBar() {
        JToolBar bar = new JToolBar();
        bar.setRollover(true);
        bar.setBorder(null);
        bar.setFloatable(false);
        bar.add(this.finishButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        return bar;
    }

    private JToolBar buildLeftToolBar() {
        JToolBar bar = new JToolBar();
        bar.setRollover(true);
        bar.setBorder(null);
        bar.setFloatable(false);
        bar.add(this.selectAllButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.deselectAllButton);
        return bar;
    }

    private JPanel buildToolBars() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(UIUtilities.buildComponentPanel(this.buildLeftToolBar()));
        p.add(UIUtilities.buildComponentPanelRight(this.buildRightToolBar()));
        return p;
    }

    private JComponent getExistingnodes(Set nodes) {
        if (nodes.size() == 0) {
            this.finishButton.setEnabled(false);
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10));
            p.add((Component)UIUtilities.setTextFont(EMPTY_NOTE), "Center");
            return p;
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            root.addChildDisplay((TreeCheckNode)i.next());
        }
        this.buildTreeNode(root, this.sorter.sort(nodes));
        dtm.reload();
        return new JScrollPane(this.tree);
    }

    private void buildGUI(Set nodes) {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TEXT, NOTE, icons.getIcon(35));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.getExistingnodes(nodes), "Center");
        c.add((Component)this.buildToolBars(), "South");
    }

    public AddExistingObjectsDialog(JFrame owner, Set nodes) {
        super(owner);
        if (nodes == null) {
            throw new IllegalArgumentException("No nodes to display.");
        }
        this.setWinProperties();
        this.initComponents();
        this.buildGUI(nodes);
        this.pack();
    }
}

