/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnail;

public class RollOverThumbnailManager {
    private static final RollOverThumbnailManager singleton = new RollOverThumbnailManager();
    private static RollOverThumbnail rollOverDialog;

    public static void stopOverDisplay() {
        RollOverThumbnailManager.rollOverDisplay(null, null, null, null);
    }

    public static void rollOverDisplay(BufferedImage image, Rectangle bounds, Point locOnScreen, String toolTip) {
        if (image == null) {
            if (rollOverDialog != null) {
                rollOverDialog.close();
                rollOverDialog = null;
            }
        } else {
            if (rollOverDialog == null) {
                rollOverDialog = new RollOverThumbnail();
            }
            rollOverDialog.setThumbnail(image, toolTip);
            rollOverDialog.pack();
            Point p = singleton.getWindowLocation(bounds, locOnScreen, rollOverDialog.getWidth(), rollOverDialog.getHeight());
            rollOverDialog.moveToFront(p);
            rollOverDialog.setVisible(true);
        }
    }

    private Point getWindowLocation(Rectangle bounds, Point locOnScreen, int winW, int winH) {
        int offsetX = Math.abs(winW - bounds.width) / 2;
        locOnScreen.y -= winH + 5;
        locOnScreen.x -= offsetX;
        return locOnScreen;
    }
}

