/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import omero.gateway.SecurityContext;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class AcquisitionDataLoader
extends BatchCallTree {
    public static final int INSTRUMENT = 0;
    public static final int IMAGE = 1;
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final SecurityContext ctx, final Object refObject) {
        return new BatchCall("Loading Acquisition data: "){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService svc = AcquisitionDataLoader.this.context.getMetadataService();
                AcquisitionDataLoader.this.result = svc.loadAcquisitionData(ctx, refObject);
            }
        };
    }

    private BatchCall makeInstrumentBatchCall(final SecurityContext ctx, final long id) {
        return new BatchCall("Loading Instrument data: "){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService svc = AcquisitionDataLoader.this.context.getMetadataService();
                AcquisitionDataLoader.this.result = svc.loadInstrument(ctx, id);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public AcquisitionDataLoader(SecurityContext ctx, Object refObject) {
        if (refObject == null) {
            throw new IllegalArgumentException("Ref Object cannot be null.");
        }
        this.loadCall = this.makeBatchCall(ctx, refObject);
    }

    public AcquisitionDataLoader(SecurityContext ctx, int type, long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Id not valid.");
        }
        switch (type) {
            case 0: {
                this.loadCall = this.makeInstrumentBatchCall(ctx, id);
                break;
            }
            case 1: {
                ImageData img = new ImageData();
                img.setId(id);
                this.loadCall = this.makeBatchCall(ctx, img);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported");
            }
        }
    }
}

