/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

class TitlePainter {
    private static final Color ROW_1 = new Color(227, 245, 238);
    private static final Color ROW_2 = new Color(242, 252, 248);
    private static final Color ROW_3 = new Color(253, 251, 251);
    private String title;
    private Font font;

    private boolean isFontSuitable(int availHeight, Graphics2D g2D) {
        FontMetrics fm = g2D.getFontMetrics(this.font);
        int maxH = fm.getMaxAscent() + fm.getMaxDescent();
        return maxH <= availHeight;
    }

    private void ensureSuitableFont(int availHeight, Graphics2D g2D) {
        float size = this.font.getSize2D();
        while (1.0f < size && !this.isFontSuitable(availHeight, g2D)) {
            this.font = this.font.deriveFont(size -= 0.5f);
        }
    }

    private String getDisplayTitle(int availWidth, Graphics2D g2D) {
        Rectangle2D bounds;
        int i;
        FontMetrics fm = g2D.getFontMetrics();
        int len = this.title.length();
        for (i = 0; i < len && !((double)availWidth < (bounds = fm.getStringBounds(this.title.substring(0, i), g2D)).getWidth()); ++i) {
        }
        if (i == len) {
            return this.title;
        }
        if (i <= 3) {
            return "...";
        }
        return this.title.substring(0, i - 3) + "...";
    }

    TitlePainter(Font fontProto) {
        if (fontProto == null) {
            throw new NullPointerException("No font proto.");
        }
        this.font = fontProto;
        this.title = "";
    }

    void setTitle(String t) {
        if (t == null) {
            t = "";
        }
        this.title = t;
    }

    void setFontStyle(int style) {
        this.font = this.font.deriveFont(style);
    }

    protected void doPaintBg(Graphics2D g2D, int width, int height) {
        for (int y = 0; y < height; y += 3) {
            g2D.setColor(ROW_1);
            g2D.drawLine(0, y, width, y);
            g2D.setColor(ROW_2);
            g2D.drawLine(0, y + 1, width, y + 1);
            g2D.setColor(ROW_3);
            g2D.drawLine(0, y + 2, width, y + 2);
        }
    }

    protected void doPaintTitle(Graphics2D g2D, int width, int height) {
        this.ensureSuitableFont(height, g2D);
        g2D.setColor(Color.BLACK);
        g2D.setFont(this.font);
        FontMetrics fm = g2D.getFontMetrics();
        int baseline = (height + fm.getAscent() - fm.getDescent()) / 2;
        g2D.drawString(this.getDisplayTitle(width, g2D), 0, baseline);
    }

    void paint(Graphics2D g2D, Rectangle titleArea, Rectangle bgArea) {
        if (g2D == null) {
            throw new NullPointerException("No graphics context.");
        }
        if (titleArea == null) {
            throw new NullPointerException("No title area.");
        }
        if (bgArea == null) {
            throw new NullPointerException("No background area.");
        }
        Graphics2D scratchGraphics = (Graphics2D)g2D.create(bgArea.x, bgArea.y, bgArea.width, bgArea.height);
        this.doPaintBg(scratchGraphics, bgArea.width, bgArea.height);
        scratchGraphics.dispose();
        scratchGraphics = (Graphics2D)g2D.create(titleArea.x, titleArea.y, titleArea.width, titleArea.height);
        this.doPaintTitle(scratchGraphics, titleArea.width, titleArea.height);
        scratchGraphics.dispose();
    }
}

