/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.BorderLayout;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;

public abstract class AbstractProject
extends JPanel
implements Project {
    private Application application;
    protected JFileChooser saveChooser;
    protected JFileChooser openChooser;
    protected File file;
    protected Executor executor;
    private HashMap actions;
    private boolean hasUnsavedChanges;
    private Preferences prefs;
    private int multipleOpenId = 1;
    private boolean isShowing;

    public void init() {
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void setApplication(Application newValue) {
        Application oldValue = this.application;
        this.application = newValue;
        this.firePropertyChange("application", oldValue, newValue);
    }

    public Application getApplication() {
        return this.application;
    }

    public JComponent getComponent() {
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File newValue) {
        File oldValue = this.file;
        this.file = newValue;
        if (this.prefs != null && newValue != null) {
            this.prefs.put("projectFile", newValue.getPath());
        }
        this.firePropertyChange("file", oldValue, newValue);
    }

    public JFileChooser getOpenChooser() {
        if (this.openChooser == null) {
            this.openChooser = this.createOpenChooser();
        }
        return this.openChooser;
    }

    protected JFileChooser createOpenChooser() {
        JFileChooser c = new JFileChooser();
        if (this.prefs != null) {
            c.setSelectedFile(new File(this.prefs.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    public JFileChooser getSaveChooser() {
        if (this.saveChooser == null) {
            this.saveChooser = this.createSaveChooser();
        }
        return this.saveChooser;
    }

    protected JFileChooser createSaveChooser() {
        JFileChooser c = new JFileChooser();
        if (this.prefs != null) {
            c.setCurrentDirectory(new File(this.prefs.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    protected void setHasUnsavedChanges(boolean newValue) {
        boolean oldValue = this.hasUnsavedChanges;
        this.hasUnsavedChanges = newValue;
        this.firePropertyChange("hasUnsavedChanges", oldValue, newValue);
    }

    public void dispose() {
    }

    public Action getAction(String id) {
        return this.actions == null ? null : (Action)this.actions.get(id);
    }

    public void putAction(String id, Action action) {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        if (action == null) {
            this.actions.remove(id);
        } else {
            this.actions.put(id, action);
        }
    }

    public void execute(Runnable worker) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.executor.execute(worker);
    }

    public void setMultipleOpenId(int newValue) {
        int oldValue = this.multipleOpenId;
        this.multipleOpenId = newValue;
        this.firePropertyChange("multipleOpenId", oldValue, newValue);
    }

    public int getMultipleOpenId() {
        return this.multipleOpenId;
    }

    public void setShowing(boolean newValue) {
        boolean oldValue = this.isShowing;
        this.isShowing = newValue;
        this.firePropertyChange("showing", oldValue, newValue);
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public void markChangesAsSaved() {
        this.setHasUnsavedChanges(false);
    }
}

