/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import application.ApplicationContext;
import application.ResourceMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jhotdraw.application.AbstractDocumentOrientedApplication;
import org.jhotdraw.application.DocumentOrientedApplication;
import org.jhotdraw.application.MyMnemonicText;

public abstract class AbstractApplicationAction
extends AbstractAction {
    private PropertyChangeListener applicationListener;
    private static final String SELECTED_KEY = "SwingSelectedKey";
    private static final String DISPLAYED_MNEMONIC_INDEX_KEY = "SwingDisplayedMnemonicIndexKey";
    private static final String LARGE_ICON_KEY = "SwingLargeIconKey";

    public AbstractApplicationAction() {
        this.installApplicationListeners(this.getApplication());
        this.updateApplicationEnabled();
    }

    protected void installApplicationListeners(DocumentOrientedApplication application) {
        if (this.applicationListener == null) {
            this.applicationListener = this.createApplicationListener();
        }
        application.addPropertyChangeListener(this.applicationListener);
    }

    protected void uninstallApplicationListeners(DocumentOrientedApplication application) {
        application.removePropertyChangeListener(this.applicationListener);
    }

    private PropertyChangeListener createApplicationListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "enabled") {
                    AbstractApplicationAction.this.updateApplicationEnabled();
                }
            }
        };
    }

    public DocumentOrientedApplication getApplication() {
        return (DocumentOrientedApplication)ApplicationContext.getInstance().getApplication();
    }

    public ResourceMap getResourceMap() {
        return ApplicationContext.getInstance().getResourceMap();
    }

    protected void updateApplicationEnabled() {
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public boolean isEnabled() {
        return this.getApplication().isEnabled() && this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", oldValue && this.getApplication().isEnabled(), newValue && this.getApplication().isEnabled());
    }

    public void initActionProperties(String baseName) {
        this.initActionProperties(this.getResourceMap(), baseName);
    }

    public void initActionProperties(ResourceMap resourceMap, String baseName) {
        Icon largeIcon;
        Icon smallIcon;
        Icon icon;
        KeyStroke key;
        Integer index;
        Integer mnemonic;
        boolean iconOrNameSpecified = false;
        Object typedName = null;
        String text = resourceMap.getString(baseName + ".Action.text", new Object[0]);
        if (text != null) {
            MyMnemonicText.configure(this, text);
            iconOrNameSpecified = true;
        }
        if ((mnemonic = resourceMap.getKeyCode(baseName + ".Action.mnemonic")) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((index = resourceMap.getKeyCode(baseName + ".Action.displayedMnemonicIndex")) != null) {
            this.putValue(DISPLAYED_MNEMONIC_INDEX_KEY, index);
        }
        if ((key = resourceMap.getKeyStroke(baseName + ".Action.accelerator")) != null) {
            this.putValue("AcceleratorKey", key);
        }
        if ((icon = resourceMap.getIcon(baseName + ".Action.icon")) != null) {
            this.putValue("SmallIcon", icon);
            this.putValue(LARGE_ICON_KEY, icon);
            iconOrNameSpecified = true;
        }
        if ((smallIcon = resourceMap.getIcon(baseName + ".Action.smallIcon")) != null) {
            this.putValue("SmallIcon", smallIcon);
            iconOrNameSpecified = true;
        }
        if ((largeIcon = resourceMap.getIcon(baseName + ".Action.largeIcon")) != null) {
            this.putValue(LARGE_ICON_KEY, largeIcon);
            iconOrNameSpecified = true;
        }
        this.putValue("ShortDescription", resourceMap.getString(baseName + ".Action.shortDescription", new Object[0]));
        this.putValue("LongDescription", resourceMap.getString(baseName + ".Action.longDescription", new Object[0]));
        this.putValue("ActionCommandKey", resourceMap.getString(baseName + ".Action.command", new Object[0]));
    }

    public ResourceMap getFrameworkResourceMap() {
        return ApplicationContext.getInstance().getResourceMap(AbstractDocumentOrientedApplication.class);
    }
}

