/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.quantum;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import ome.model.core.Pixels;
import ome.model.display.QuantumDef;
import omeis.providers.re.quantum.PolynomialMap;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumStrategy;

public class Quantization_32_bit
extends QuantumStrategy {
    private int min;
    private int max;
    private double ysNormalized;
    private double yeNormalized;
    private double aNormalized;
    private double Q1;
    private double Q9;
    private double aDecile;
    private double bDecile;
    private int cdStart;
    private int cdEnd;
    private LoadingCache<Double, Integer> values = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Double, Integer>(){

        public Integer load(Double key) throws Exception {
            return Quantization_32_bit.this._quantize(key);
        }
    });

    private void initNormalizedMap(double k) {
        this.ysNormalized = this.valueMapper.transform(0, k);
        this.yeNormalized = this.valueMapper.transform(255, k);
        this.aNormalized = (double)this.qDef.getBitResolution().intValue() / (this.yeNormalized - this.ysNormalized);
    }

    private double initDecileMap(double dStart, double dEnd) {
        this.cdStart = this.qDef.getCdStart();
        this.cdEnd = this.qDef.getCdEnd();
        double denum = dEnd - dStart;
        double num = 255.0;
        double v = 0.0;
        double b = dStart;
        int e = 0;
        double startMin = this.min;
        double startMax = this.max;
        this.Q1 = this.min;
        this.Q9 = this.max;
        if (dStart <= startMin) {
            this.Q1 = dStart;
        }
        if (dEnd >= startMax) {
            this.Q9 = dEnd;
        }
        if (startMin == startMax) {
            v = 1.0;
        }
        double decile = (startMax - startMin) / 10.0;
        if (this.getNoiseReduction()) {
            this.Q1 += decile;
            this.Q9 -= decile;
            denum = this.Q9 - this.Q1;
            v = 10.0;
            e = 10;
            num = 235.0;
            b = this.Q1;
            if (dStart >= this.Q1 && dEnd > this.Q9) {
                denum = this.Q9 - dStart;
                b = dStart;
            } else if (dStart >= this.Q1 && dEnd <= this.Q9) {
                denum = dEnd - dStart;
                b = dStart;
            } else if (dStart < this.Q1 && dEnd <= this.Q9) {
                denum = dEnd - this.Q1;
            }
            if (this.cdStart < 10) {
                this.cdStart = 10;
            }
            if (this.cdEnd > 245) {
                this.cdEnd = 245;
            }
        }
        this.aDecile = num / denum;
        this.bDecile = this.aDecile * b - (double)e;
        return v;
    }

    @Override
    protected void onWindowChange() {
        this.values.invalidateAll();
    }

    private int _quantize(double value) throws QuantizationException {
        double dStart = this.getWindowStart();
        double dEnd = this.getWindowEnd();
        double k = this.getCurveCoefficient();
        double a1 = (double)(this.qDef.getCdEnd() - this.qDef.getCdStart()) / this.qDef.getBitResolution().doubleValue();
        this.initNormalizedMap(k);
        double v = this.initDecileMap(dStart, dEnd);
        PolynomialMap normalize = new PolynomialMap();
        v = value > this.Q1 ? (value <= this.Q9 ? this.aDecile * normalize.transform(value, 1.0) - this.bDecile : (double)this.cdEnd) : (double)this.cdStart;
        v = this.aNormalized * (this.valueMapper.transform(v, k) - this.ysNormalized);
        v = Math.round(v);
        v = Math.round(a1 * v + (double)this.cdStart);
        return (byte)v & 0xFF;
    }

    public Quantization_32_bit(QuantumDef qd, Pixels pixels) {
        super(qd, pixels);
    }

    @Override
    public int quantize(double value) throws QuantizationException {
        try {
            return (Integer)this.values.get((Object)this.getMiddleRange(value));
        }
        catch (ExecutionException e) {
            throw new QuantizationException(e);
        }
    }
}

