/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.EndpointSelectionType;
import Ice.LocalException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointI_connectors;
import IceInternal.HashUtil;
import IceInternal.IPEndpointI;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.WSAcceptor;
import IceInternal.WSConnector;
import IceInternal.WSEndpointDelegate;
import java.util.ArrayList;
import java.util.List;

final class WSEndpoint
extends EndpointI {
    private ProtocolInstance _instance;
    private IPEndpointI _delegate;
    private String _resource;

    public WSEndpoint(ProtocolInstance instance, EndpointI del, String res) {
        this._instance = instance;
        this._delegate = (IPEndpointI)del;
        this._resource = res;
    }

    public WSEndpoint(ProtocolInstance instance, EndpointI del, ArrayList<String> args) {
        this._instance = instance;
        this._delegate = (IPEndpointI)del;
        this.initWithOptions(args);
        if (this._resource == null) {
            this._resource = "/";
        }
    }

    public WSEndpoint(ProtocolInstance instance, EndpointI del, BasicStream s) {
        this._instance = instance;
        this._delegate = (IPEndpointI)del;
        this._resource = s.readString();
    }

    @Override
    public EndpointInfo getInfo() {
        assert (this._delegate instanceof WSEndpointDelegate);
        return ((WSEndpointDelegate)((Object)this._delegate)).getWSInfo(this._resource);
    }

    @Override
    public short type() {
        return this._delegate.type();
    }

    @Override
    public String protocol() {
        return this._delegate.protocol();
    }

    @Override
    public void streamWrite(BasicStream s) {
        s.startWriteEncaps();
        this._delegate.streamWriteImpl(s);
        s.writeString(this._resource);
        s.endWriteEncaps();
    }

    @Override
    public int timeout() {
        return this._delegate.timeout();
    }

    @Override
    public EndpointI timeout(int timeout) {
        if (timeout == this._delegate.timeout()) {
            return this;
        }
        return new WSEndpoint(this._instance, this._delegate.timeout(timeout), this._resource);
    }

    @Override
    public String connectionId() {
        return this._delegate.connectionId();
    }

    @Override
    public EndpointI connectionId(String connectionId) {
        if (connectionId.equals(this._delegate.connectionId())) {
            return this;
        }
        return new WSEndpoint(this._instance, this._delegate.connectionId(connectionId), this._resource);
    }

    @Override
    public boolean compress() {
        return this._delegate.compress();
    }

    @Override
    public EndpointI compress(boolean compress) {
        if (compress == this._delegate.compress()) {
            return this;
        }
        return new WSEndpoint(this._instance, this._delegate.compress(compress), this._resource);
    }

    @Override
    public boolean datagram() {
        return this._delegate.datagram();
    }

    @Override
    public boolean secure() {
        return this._delegate.secure();
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public void connectors_async(EndpointSelectionType selType, final EndpointI_connectors callback) {
        EndpointI_connectors cb = new EndpointI_connectors(){

            @Override
            public void connectors(List<Connector> connectors) {
                ArrayList<Connector> l = new ArrayList<Connector>();
                for (Connector c : connectors) {
                    l.add(new WSConnector(WSEndpoint.this._instance, c, WSEndpoint.this._delegate.host(), WSEndpoint.this._delegate.port(), WSEndpoint.this._resource));
                }
                callback.connectors(l);
            }

            @Override
            public void exception(LocalException ex) {
                callback.exception(ex);
            }
        };
        this._delegate.connectors_async(selType, cb);
    }

    @Override
    public Acceptor acceptor(String adapterName) {
        Acceptor delAcc = this._delegate.acceptor(adapterName);
        return new WSAcceptor(this, this._instance, delAcc);
    }

    public WSEndpoint endpoint(EndpointI delEndp) {
        return new WSEndpoint(this._instance, delEndp, this._resource);
    }

    @Override
    public List<EndpointI> expand() {
        List<EndpointI> endps = this._delegate.expand();
        ArrayList<EndpointI> l = new ArrayList<EndpointI>();
        for (EndpointI e : endps) {
            l.add(e == this._delegate ? this : new WSEndpoint(this._instance, e, this._resource));
        }
        return l;
    }

    @Override
    public boolean equivalent(EndpointI endpoint) {
        if (!(endpoint instanceof WSEndpoint)) {
            return false;
        }
        WSEndpoint wsEndpointI = (WSEndpoint)endpoint;
        return this._delegate.equivalent(wsEndpointI._delegate);
    }

    public synchronized int hashCode() {
        int h = this._delegate.hashCode();
        h = HashUtil.hashAdd(h, this._resource);
        return h;
    }

    @Override
    public String options() {
        String s = this._delegate.options();
        if (this._resource != null && this._resource.length() > 0) {
            boolean addQuote;
            s = s + " -r ";
            boolean bl = addQuote = this._resource.indexOf(58) != -1;
            if (addQuote) {
                s = s + "\"";
            }
            s = s + this._resource;
            if (addQuote) {
                s = s + "\"";
            }
        }
        return s;
    }

    @Override
    public int compareTo(EndpointI obj) {
        if (!(obj instanceof WSEndpoint)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        WSEndpoint p = (WSEndpoint)obj;
        if (this == p) {
            return 0;
        }
        int v = this._resource.compareTo(p._resource);
        if (v != 0) {
            return v;
        }
        return this._delegate.compareTo(p._delegate);
    }

    public EndpointI delegate() {
        return this._delegate;
    }

    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        switch (option.charAt(1)) {
            case 'r': {
                if (argument == null) {
                    throw new EndpointParseException("no argument provided for -r option in endpoint " + endpoint + this._delegate.options());
                }
                this._resource = argument;
                return true;
            }
        }
        return false;
    }
}

