/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawingEditor
extends AbstractBean
implements DrawingEditor,
ToolListener {
    private HashMap<AttributeKey, Object> defaultAttributes = new HashMap();
    private Tool tool;
    private HashSet<DrawingView> views;
    private DrawingView activeView;
    private boolean isEnabled = true;
    private FocusListener focusHandler = new FocusListener(){

        public void focusGained(FocusEvent e) {
            DefaultDrawingEditor.this.setActiveView(DefaultDrawingEditor.this.findView((Container)e.getSource()));
        }

        public void focusLost(FocusEvent e) {
        }
    };

    public DefaultDrawingEditor() {
        this.setDefaultAttribute(AttributeKeys.FILL_COLOR, Color.white);
        this.setDefaultAttribute(AttributeKeys.STROKE_COLOR, Color.black);
        this.setDefaultAttribute(AttributeKeys.TEXT_COLOR, Color.black);
        this.views = new HashSet();
    }

    @Override
    public void setTool(Tool t) {
        if (t == this.tool) {
            return;
        }
        if (this.tool != null) {
            for (DrawingView v : this.views) {
                v.removeMouseListener(this.tool);
                v.removeMouseMotionListener(this.tool);
                v.removeKeyListener(this.tool);
            }
            this.tool.deactivate(this);
            this.tool.removeToolListener(this);
        }
        this.tool = t;
        if (this.tool != null) {
            this.tool.activate(this);
            for (DrawingView v : this.views) {
                v.addMouseListener(this.tool);
                v.addMouseMotionListener(this.tool);
                v.addKeyListener(this.tool);
            }
            this.tool.addToolListener(this);
        }
    }

    @Override
    public void areaInvalidated(ToolEvent evt) {
        Rectangle r = evt.getInvalidatedArea();
        evt.getView().getComponent().repaint(r.x, r.y, r.width, r.height);
    }

    @Override
    public void toolStarted(ToolEvent evt) {
        this.setActiveView(evt.getView());
    }

    @Override
    public void setActiveView(DrawingView newValue) {
        DrawingView oldValue = this.activeView;
        this.activeView = newValue;
        this.firePropertyChange("activeView", oldValue, newValue);
    }

    @Override
    public void toolDone(ToolEvent evt) {
        DrawingView v = this.getActiveView();
        if (v != null) {
            JComponent c = v.getComponent();
            c.invalidate();
            if (c.getParent() != null) {
                c.getParent().validate();
            }
        }
    }

    @Override
    public Tool getTool() {
        return this.tool;
    }

    @Override
    public DrawingView getActiveView() {
        return this.activeView != null ? this.activeView : (this.views.size() == 0 ? null : this.views.iterator().next());
    }

    private void updateActiveView() {
        for (DrawingView v : this.views) {
            if (!v.getComponent().hasFocus()) continue;
            this.setActiveView(v);
            return;
        }
        this.setActiveView(null);
    }

    @Override
    public void applyDefaultAttributesTo(Figure f) {
        for (Map.Entry<AttributeKey, Object> entry : this.defaultAttributes.entrySet()) {
            f.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object getDefaultAttribute(AttributeKey key) {
        return this.defaultAttributes.get(key);
    }

    @Override
    public void setDefaultAttribute(AttributeKey key, Object newValue) {
        Object oldValue = this.defaultAttributes.put(key, newValue);
        this.firePropertyChange(key.getKey(), oldValue, newValue);
    }

    @Override
    public void remove(DrawingView view) {
        view.getComponent().removeFocusListener(this.focusHandler);
        this.views.remove(view);
        if (this.tool != null) {
            view.removeMouseListener(this.tool);
            view.removeMouseMotionListener(this.tool);
            view.removeKeyListener(this.tool);
        }
        view.removeNotify(this);
        if (this.activeView == view) {
            view = this.views.size() > 0 ? this.views.iterator().next() : null;
        }
        this.updateActiveView();
    }

    @Override
    public void add(DrawingView view) {
        this.views.add(view);
        view.addNotify(this);
        view.getComponent().addFocusListener(this.focusHandler);
        if (this.tool != null) {
            view.addMouseListener(this.tool);
            view.addMouseMotionListener(this.tool);
            view.addKeyListener(this.tool);
        }
        this.updateActiveView();
    }

    @Override
    public void setCursor(Cursor c) {
    }

    @Override
    public Collection<DrawingView> getDrawingViews() {
        return Collections.unmodifiableCollection(this.views);
    }

    @Override
    public DrawingView findView(Container c) {
        for (DrawingView v : this.views) {
            if (v.getComponent() != c) continue;
            return v;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (newValue != this.isEnabled) {
            boolean oldValue = this.isEnabled;
            this.isEnabled = newValue;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Map<AttributeKey, Object> getDefaultAttributes() {
        return Collections.unmodifiableMap(this.defaultAttributes);
    }
}

