/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class ThumbnailProvider
implements Thumbnail {
    private static final double ZOOM_FACTOR = 1.5;
    private static final int BORDER = 1;
    private static final Color BORDER_COLOR = Color.WHITE;
    private DataObject imgInfo;
    private ImageNode display;
    private int width;
    private int height;
    private int originalWidth;
    private int originalHeight;
    private BufferedImage fullScaleThumb;
    private BufferedImage displayThumb;
    private BufferedImage fullSizeImage;
    private double scalingFactor;
    private Icon iconThumb;
    private boolean valid;

    private void computeDims() {
        double scale = DataBrowserFactory.getThumbnailScaleFactor();
        PixelsData pxd = null;
        this.width = (int)(96.0 * scale);
        this.height = (int)(96.0 * scale);
        this.originalWidth = 96;
        this.originalHeight = 96;
        try {
            if (!(this.imgInfo instanceof ImageData)) {
                return;
            }
            pxd = ((ImageData)this.imgInfo).getDefaultPixels();
        }
        catch (Exception e) {
            this.width = (int)(96.0 * scale);
            this.height = (int)(96.0 * scale);
            this.originalWidth = 96;
            this.originalHeight = 96;
            return;
        }
        if (pxd == null) {
            this.width = (int)(96.0 * scale);
            this.height = (int)(96.0 * scale);
            this.originalWidth = 96;
            this.originalHeight = 96;
            return;
        }
        double pixSizeX = pxd.getSizeX();
        double pixSizeY = pxd.getSizeY();
        Dimension size = Factory.computeThumbnailSize(this.width, this.height, pixSizeX, pixSizeY);
        this.width = size.width;
        this.height = size.height;
        size = Factory.computeThumbnailSize(this.originalWidth, this.originalHeight, pixSizeX, pixSizeY);
        this.originalWidth = size.width;
        this.originalHeight = size.height;
    }

    public ThumbnailProvider(DataObject is) {
        if (is == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (!(is instanceof ImageData || is instanceof ExperimenterData || is instanceof FileData)) {
            throw new IllegalArgumentException("Objet to supported.");
        }
        this.imgInfo = is;
        this.scalingFactor = DataBrowserFactory.getThumbnailScaleFactor();
        this.computeDims();
        this.valid = true;
    }

    @Override
    public void setImageNode(ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No Image node");
        }
        this.display = node;
    }

    @Override
    public void setFullScaleThumb(BufferedImage t) {
        this.flush();
        this.fullScaleThumb = t;
        if (this.fullScaleThumb != null) {
            this.scale(this.scalingFactor);
        }
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
        if (!valid && this.display != null) {
            Registry reg = DataBrowserAgent.getRegistry();
            Boolean bl = (Boolean)reg.lookup("/views/DisplayNonValidImage");
        }
    }

    @Override
    public BufferedImage getDisplayedImage() {
        return this.displayThumb;
    }

    @Override
    public void scale(double f) {
        if (f < 0.25 || f > 2.5) {
            return;
        }
        this.scalingFactor = f;
        int w = (int)((double)this.originalWidth * f);
        int h = (int)((double)this.originalHeight * f);
        if (this.fullScaleThumb != null) {
            this.displayThumb = Factory.magnifyImage(f, this.fullScaleThumb);
            w = this.displayThumb.getWidth();
            h = this.displayThumb.getHeight();
        }
        if (this.display != null) {
            this.display.setCanvasSize(w, h);
            this.display.pack();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public BufferedImage getFullScaleThumb() {
        return this.fullScaleThumb;
    }

    @Override
    public BufferedImage getZoomedFullScaleThumb() {
        return Factory.magnifyImage(1.5, this.fullScaleThumb);
    }

    @Override
    public Icon getIcon() {
        if (this.iconThumb != null) {
            return this.iconThumb;
        }
        if (this.fullScaleThumb == null) {
            return null;
        }
        BufferedImage img = Factory.magnifyImage(0.16, this.fullScaleThumb);
        BufferedImage newImg = new BufferedImage(img.getWidth() + 2, img.getHeight() + 2, img.getType());
        Graphics g = newImg.getGraphics();
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(BORDER_COLOR);
        g2D.fillRect(0, 0, newImg.getWidth(), newImg.getHeight());
        g2D.drawImage(img, null, 1, 1);
        this.iconThumb = new ImageIcon(newImg);
        img.flush();
        return this.iconThumb;
    }

    @Override
    public Icon getIcon(double magnification) {
        if (magnification <= 0.0) {
            magnification = 0.16;
        }
        if (this.fullScaleThumb == null) {
            return null;
        }
        BufferedImage img = Factory.magnifyImage(magnification, this.fullScaleThumb);
        BufferedImage newImg = new BufferedImage(img.getWidth() + 2, img.getHeight() + 2, img.getType());
        Graphics g = newImg.getGraphics();
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(BORDER_COLOR);
        g2D.fillRect(0, 0, newImg.getWidth(), newImg.getHeight());
        g2D.drawImage(img, null, 1, 1);
        img.flush();
        return new ImageIcon(newImg);
    }

    @Override
    public boolean isThumbnailLoaded() {
        return this.fullScaleThumb != null;
    }

    @Override
    public void setFullSizeImage(BufferedImage image) {
        this.fullSizeImage = image;
    }

    @Override
    public BufferedImage getFullSizeImage() {
        return this.fullSizeImage;
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this.originalWidth, this.originalHeight);
    }

    @Override
    public void flush() {
        this.fullSizeImage = null;
        this.displayThumb = null;
        this.fullScaleThumb = null;
    }
}

