/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.redesign;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ContentViewer;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ModuleContentTableModel;

public class ObjectTable
extends JPanel {
    private List<ModuleContent> availableObjects;
    private int currentSelection;

    public ObjectTable(List<ModuleContent> availableElems) {
        if (availableElems != null) {
            this.availableObjects = availableElems;
        }
        this.currentSelection = -1;
    }

    public ObjectTable(ObjectTable orig) {
        if (orig != null) {
            if (orig.availableObjects != null) {
                this.availableObjects = new ArrayList<ModuleContent>();
                for (ModuleContent c : orig.availableObjects) {
                    this.availableObjects.add(new ModuleContent(c));
                }
            }
            this.currentSelection = orig.currentSelection;
        }
    }

    public void setCurrentSelected(int index) {
        this.currentSelection = index;
    }

    public int getOriginalIndex(String id) {
        int oidx = 0;
        for (ModuleContent c : this.availableObjects) {
            if (c.getAttributeValue("ID").equals(id)) {
                return oidx;
            }
            ++oidx;
        }
        return -1;
    }

    public int getElementIndex(ModuleContent elem) {
        int idx = 0;
        if (this.currentSelection != -1) {
            return this.currentSelection;
        }
        if (this.availableObjects != null && elem.getList() != null) {
            for (ModuleContent c : this.availableObjects) {
                if (MDEHelper.isEqual(c, elem)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    protected JTable getObjectTable() {
        JTable table = new JTable();
        ModuleContentTableModel dataModel = null;
        if (this.availableObjects != null && this.availableObjects.size() > 0) {
            dataModel = new ModuleContentTableModel(this.availableObjects.get(0).getIdents());
            for (int i = 0; i < this.availableObjects.size(); ++i) {
                dataModel.addRow(this.availableObjects.get(i));
            }
        }
        if (dataModel != null) {
            table.setModel(dataModel);
        }
        table.setSelectionMode(0);
        table.setPreferredScrollableViewportSize(new Dimension(table.getWidth(), 60));
        table.setFillsViewportHeight(true);
        return table;
    }

    public JPanel buildGUI(int selectedIndex, int originalIndex, ContentViewer contentViewer) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.currentSelection = selectedIndex;
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(5, 5));
        pane.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel label = new JLabel("Available Elements:");
        label.setFont(new Font("Tahoma", 1, 11));
        JTable table = this.getObjectTable();
        if (selectedIndex != -1) {
            table.setRowSelectionInterval(selectedIndex, selectedIndex);
        }
        this.addListSelectionListener(contentViewer, table);
        JScrollPane scrollPane = new JScrollPane(table);
        pane.add((Component)label, "North");
        pane.add((Component)scrollPane, "Center");
        panel.add((Component)pane, "Center");
        return panel;
    }

    private void addListSelectionListener(final ContentViewer contentViewer, JTable table) {
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm == null || lsm.isSelectionEmpty()) {
                        return;
                    }
                    int idx = -1;
                    if (lsm.isSelectedIndex(e.getFirstIndex())) {
                        idx = e.getFirstIndex();
                    } else if (lsm.isSelectedIndex(e.getLastIndex())) {
                        idx = e.getLastIndex();
                    }
                    if (idx > -1 && idx < ObjectTable.this.availableObjects.size()) {
                        ModuleContent c = ObjectTable.this.availableObjects.get(idx);
                        ModuleContent origContent = null;
                        if (ObjectTable.this.currentSelection != -1) {
                            origContent = ObjectTable.this.availableObjects.get(ObjectTable.this.currentSelection);
                        }
                        ObjectTable.this.currentSelection = idx;
                        contentViewer.replaceData(c, origContent);
                    }
                }
            }
        };
        if (table != null) {
            table.getSelectionModel().addListSelectionListener(listener);
        }
    }
}

