/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.ImportFromTemplateFile;

public class TypeFilter_GUI
extends JDialog
implements ActionListener {
    private JPanel panel_chBoxes;
    private JButton btn_OK;
    private JButton btn_cancel;
    private JCheckBox btn_select_all;
    private List<String> filterList = new ArrayList<String>();

    public TypeFilter_GUI(JFrame parent, DefaultMutableTreeNode root) {
        super((Frame)parent, "Filter For Object Type");
        this.panel_chBoxes = new JPanel(new GridLayout(0, 1));
        TitledBorder border = BorderFactory.createTitledBorder("Object Types");
        this.panel_chBoxes.setBorder(border);
        this.generateListFromTree(root);
        this.revalidate();
        this.repaint();
        this.build_GUI();
        this.pack();
        this.setVisible(true);
    }

    public TypeFilter_GUI(JFrame parent, String path) {
        super((Frame)parent, "Filter For Object Type");
        this.panel_chBoxes = new JPanel(new GridLayout(0, 1));
        TitledBorder border = BorderFactory.createTitledBorder("Object Types");
        this.panel_chBoxes.setBorder(border);
        this.generateListFromFile(path);
        this.revalidate();
        this.repaint();
        this.build_GUI();
        this.pack();
        this.setVisible(true);
    }

    private void build_GUI() {
        this.btn_OK = new JButton("OK");
        this.btn_OK.addActionListener(this);
        this.btn_cancel = new JButton("Cancel");
        this.btn_cancel.addActionListener(this);
        Box btnPane = Box.createHorizontalBox();
        btnPane.add(this.btn_cancel);
        btnPane.add(Box.createHorizontalStrut(5));
        btnPane.add(this.btn_OK);
        this.btn_select_all = new JCheckBox("Select all");
        this.btn_select_all.setSelected(true);
        this.btn_select_all.addActionListener(this);
        this.setBounds(100, 100, 500, 600);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.setModal(true);
        this.getContentPane().add((Component)this.btn_select_all, "North");
        this.getContentPane().add((Component)this.panel_chBoxes, "Center");
        this.getContentPane().add((Component)btnPane, "South");
    }

    private void generateListFromFile(String path) {
        ImportFromTemplateFile importer = new ImportFromTemplateFile(path);
        List<String> list = importer.createTypeList();
        if (list != null) {
            for (String type : list) {
                JCheckBox ch = new JCheckBox(type);
                ch.setSelected(true);
                ch.addActionListener(this);
                this.panel_chBoxes.add(ch);
                this.filterList.add(type);
            }
        }
    }

    private void generateListFromTree(DefaultMutableTreeNode root) {
        List<String> list = MDEHelper.getTypes(root);
        if (list != null) {
            for (String type : list) {
                JCheckBox ch = new JCheckBox(type);
                ch.setSelected(true);
                ch.addActionListener(this);
                this.panel_chBoxes.add(ch);
                this.filterList.add(type);
            }
        }
    }

    public List<String> getTypeFilter() {
        return this.filterList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btn_OK) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.btn_cancel) {
            this.filterList = null;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() instanceof JCheckBox) {
            if (e.getSource() == this.btn_select_all) {
                this.selectAll(this.btn_select_all.isSelected());
            } else if (((JCheckBox)e.getSource()).isSelected()) {
                this.filterList.add(((JCheckBox)e.getSource()).getText());
            } else if (!((JCheckBox)e.getSource()).isSelected()) {
                this.filterList.remove(((JCheckBox)e.getSource()).getText());
            }
        }
    }

    private void selectAll(boolean b) {
        for (Component c : this.panel_chBoxes.getComponents()) {
            if (b && !((JCheckBox)c).isSelected()) {
                this.filterList.add(((JCheckBox)c).getText());
            }
            ((JCheckBox)c).setSelected(b);
        }
        if (!b) {
            this.filterList = new ArrayList<String>();
        }
    }
}

