/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class SoftwareUpdateDialog
extends JDialog {
    static final String OPEN_URL_PROPERTY = "openURL";
    private JButton closeButton;

    private void setWindowProperties() {
        this.setModal(true);
        this.setResizable(false);
    }

    private void initComponents() {
        this.closeButton = new JButton("OK");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwareUpdateDialog.this.close();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SoftwareUpdateDialog.this.close();
            }
        });
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.closeButton);
        return bar;
    }

    private JPanel buildAbout(String aboutMessage) {
        JPanel content = new JPanel();
        double[][] size = new double[][]{{-2.0, 5.0, -1.0}, {-1.0}};
        content.setLayout((LayoutManager)new TableLayout((double[][])size));
        Icon icon = IconManager.getLogoAbout();
        JEditorPane p = UIUtilities.buildTextEditorPane(aboutMessage);
        p.setEditable(false);
        p.setOpaque(false);
        p.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    String url = e.getURL().toString();
                    SoftwareUpdateDialog.this.firePropertyChange(SoftwareUpdateDialog.OPEN_URL_PROPERTY, null, url);
                }
            }
        });
        p.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        p.setBackground(Color.WHITE);
        p.setOpaque(true);
        JLabel l = new JLabel(icon);
        l.setBackground(Color.WHITE);
        content.setBackground(Color.WHITE);
        content.add((Component)l, "0, 0");
        content.add((Component)p, "1, 0, 2, 0");
        JPanel c = new JPanel();
        c.setLayout(new BoxLayout(c, 1));
        c.add(content);
        c.add(new JSeparator());
        c.setOpaque(true);
        return c;
    }

    private void buildGUI(String aboutMessage) {
        Container c = this.getContentPane();
        c.add((Component)this.buildAbout(aboutMessage), "North");
        JPanel p = UIUtilities.buildComponentPanelRight(this.buildToolBar());
        p.setOpaque(true);
        c.add((Component)p, "South");
    }

    SoftwareUpdateDialog(JFrame owner, String aboutMessage) {
        super(owner);
        this.setWindowProperties();
        this.initComponents();
        this.buildGUI(aboutMessage);
        this.pack();
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }
}

