/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import omero.log.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.data.model.AnalysisActivityParam;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadAndLaunchActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadAndZipParam;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.data.model.ExportActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureActivityParam;
import org.openmicroscopy.shoola.env.data.model.MovieActivityParam;
import org.openmicroscopy.shoola.env.data.model.OpenActivityParam;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.env.data.model.SaveAsParam;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.data.model.TransferableActivityParam;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.AnalysisActivity;
import org.openmicroscopy.shoola.env.ui.ChangesDialog;
import org.openmicroscopy.shoola.env.ui.DataTransferActivity;
import org.openmicroscopy.shoola.env.ui.DeleteActivity;
import org.openmicroscopy.shoola.env.ui.DownloadActivity;
import org.openmicroscopy.shoola.env.ui.DownloadAndLaunchActivity;
import org.openmicroscopy.shoola.env.ui.DownloadAndZipActivity;
import org.openmicroscopy.shoola.env.ui.DownloadArchivedActivity;
import org.openmicroscopy.shoola.env.ui.ExportActivity;
import org.openmicroscopy.shoola.env.ui.FigureActivity;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.MovieActivity;
import org.openmicroscopy.shoola.env.ui.OpenObjectActivity;
import org.openmicroscopy.shoola.env.ui.SaveAsActivity;
import org.openmicroscopy.shoola.env.ui.SaveResultsActivity;
import org.openmicroscopy.shoola.env.ui.ScriptActivity;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierManager;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class UserNotifierImpl
implements UserNotifier,
PropertyChangeListener {
    private static final String DEFAULT_ERROR_TITLE = "Error";
    private static final String DEFAULT_WARNING_TITLE = "Warning";
    private static final String DEFAULT_INFO_TITLE = "Information";
    private static JFrame SHARED_FRAME = null;
    private UserNotifierManager manager;
    private ChangesDialog dialog;

    private boolean canWriteInFolder(File folder) {
        if (folder == null) {
            this.notifyInfo("Download file", "The selected folder does not exist.\nPlease select a different one.");
            return false;
        }
        if (!folder.canWrite()) {
            this.notifyInfo("Download file", "The selected folder is write protected.\nPlease select a different one.");
            return false;
        }
        return true;
    }

    private String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private void showNotificationDialog(String title, String message, Icon icon) {
        NotificationDialog dialog = new NotificationDialog(SHARED_FRAME, title, message, icon);
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    private String getEmail(String email) {
        if (email != null && email.trim().length() != 0) {
            return email;
        }
        ExperimenterData exp = this.manager.getExperimenter();
        if (exp != null) {
            email = exp.getEmail();
        }
        if (email == null) {
            email = "";
        }
        return email;
    }

    private void showErrorDialog(String title, String summary, String detail, String email) {
        Exception e;
        if (detail == null) {
            if (summary == null) {
                summary = "";
            }
            e = new Exception(summary);
        } else {
            e = new Exception(detail);
        }
        if (CommonsLangUtils.isEmpty(title)) {
            title = DEFAULT_ERROR_TITLE;
        }
        MessengerDialog d = new MessengerDialog(SHARED_FRAME, title, this.getEmail(email), e);
        d.setServerVersion(this.manager.getServerVersion());
        d.addPropertyChangeListener(this.manager);
        d.setModal(true);
        UIUtilities.centerAndShow(d);
    }

    UserNotifierImpl(Container c) {
        this.manager = new UserNotifierManager(this, c);
        if (SHARED_FRAME == null) {
            SHARED_FRAME = new JFrame();
            SHARED_FRAME.setIconImage(AbstractIconManager.getOMEImageIcon());
        }
    }

    void showActivity() {
        this.manager.showActivity();
    }

    void notifySaving(List<Object> nodes, PropertyChangeListener listener, SecurityContext ctx) {
        this.dialog = new ChangesDialog(SHARED_FRAME, nodes, ctx);
        this.dialog.addPropertyChangeListener(this);
        if (listener != null) {
            this.dialog.addPropertyChangeListener(listener);
        }
        UIUtilities.centerAndShow(this.dialog);
    }

    @Override
    public void notifyError(String title, String summary) {
        if (CommonsLangUtils.isEmpty(title)) {
            title = DEFAULT_ERROR_TITLE;
        }
        this.showNotificationDialog(title, summary, IconManager.getDefaultErrorIcon());
    }

    @Override
    public void notifyError(String title, String summary, Throwable detail) {
        this.notifyError(title, summary, detail == null ? null : this.printErrorText(detail));
    }

    @Override
    public void notifyError(String title, String summary, String email, List<ImportErrorObject> toSubmit, PropertyChangeListener listener) {
        if (CommonsLangUtils.isEmpty(title)) {
            title = DEFAULT_ERROR_TITLE;
        }
        if (email == null) {
            email = "";
        }
        MessengerDialog d = new MessengerDialog(SHARED_FRAME, title, this.getEmail(email), toSubmit);
        d.setServerVersion(this.manager.getServerVersion());
        d.addPropertyChangeListener(this.manager);
        if (listener != null) {
            d.addPropertyChangeListener(listener);
        }
        if (!CollectionUtils.isEmpty(toSubmit)) {
            d.setModal(false);
            d.setAlwaysOnTop(false);
        }
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void notifyError(String title, String summary, String detail) {
        this.showErrorDialog(title, summary, detail, null);
    }

    @Override
    public void notifyWarning(String title, String message) {
        if (CommonsLangUtils.isEmpty(title)) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultWarnIcon());
    }

    @Override
    public void notifyWarning(String title, String summary, String detail) {
        if (CommonsLangUtils.isEmpty(title)) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showErrorDialog(title, summary, detail, null);
    }

    @Override
    public void notifyWarning(String title, String summary, Throwable detail) {
        this.notifyWarning(title, summary, detail == null ? null : detail.getMessage());
    }

    @Override
    public void notifyInfo(String title, String message) {
        if (CommonsLangUtils.isEmpty(title)) {
            title = DEFAULT_INFO_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultInfoIcon());
    }

    @Override
    public void notifyInfo(String title, String message, Icon icon) {
        if (CommonsLangUtils.isEmpty(title)) {
            title = DEFAULT_INFO_TITLE;
        }
        if (icon == null) {
            icon = IconManager.getDefaultInfoIcon();
        }
        this.showNotificationDialog(title, message, icon);
    }

    @Override
    public void submitMessage(String email, String comment) {
        MessengerDialog d = this.manager.getCommentDialog(SHARED_FRAME, this.getEmail(email));
        d.setComment(comment);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void notifyActivity(SecurityContext ctx, Object activity) {
        if (activity == null) {
            return;
        }
        ActivityComponent comp = null;
        boolean register = true;
        boolean uiRegister = true;
        boolean startActivity = true;
        if (activity instanceof MovieActivityParam) {
            MovieActivityParam p = (MovieActivityParam)activity;
            comp = new MovieActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof ExportActivityParam) {
            if (this.manager.hasRunningActivityOfType(ExportActivity.class)) {
                startActivity = false;
            }
            ExportActivityParam p = (ExportActivityParam)activity;
            comp = new ExportActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof DownloadAndLaunchActivityParam) {
            DownloadAndLaunchActivityParam p = (DownloadAndLaunchActivityParam)activity;
            comp = new DownloadAndLaunchActivity((UserNotifier)this, this.manager.getRegistry(), ctx, p);
            uiRegister = p.isUIRegister();
        } else if (activity instanceof DownloadActivityParam) {
            DownloadActivityParam p = (DownloadActivityParam)activity;
            File f = p.getFolder();
            if (!f.isDirectory()) {
                f = f.getParentFile();
            }
            if (!this.canWriteInFolder(f)) {
                return;
            }
            uiRegister = p.isUIRegister();
            comp = new DownloadActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof FigureActivityParam) {
            FigureActivityParam p = (FigureActivityParam)activity;
            comp = new FigureActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof AnalysisActivityParam) {
            AnalysisActivityParam p = (AnalysisActivityParam)activity;
            comp = new AnalysisActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof ScriptActivityParam) {
            ScriptActivityParam p = (ScriptActivityParam)activity;
            comp = new ScriptActivity(this, this.manager.getRegistry(), ctx, p.getScript(), p.getIndex());
        } else if (activity instanceof DownloadArchivedActivityParam) {
            DownloadArchivedActivityParam p = (DownloadArchivedActivityParam)activity;
            comp = new DownloadArchivedActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof DeleteActivityParam) {
            DeleteActivityParam p = (DeleteActivityParam)activity;
            comp = new DeleteActivity((UserNotifier)this, this.manager.getRegistry(), p);
            uiRegister = p.isUIRegister();
        } else if (activity instanceof OpenActivityParam) {
            OpenActivityParam p = (OpenActivityParam)activity;
            comp = new OpenObjectActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof DownloadAndZipParam) {
            DownloadAndZipParam p = (DownloadAndZipParam)activity;
            if (!this.canWriteInFolder(p.getFolder())) {
                return;
            }
            comp = new DownloadAndZipActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof SaveAsParam) {
            SaveAsParam p = (SaveAsParam)activity;
            File folder = p.getFolder();
            if (folder != null && (folder.isFile() || !folder.exists())) {
                folder = folder.getParentFile();
            }
            if (!this.canWriteInFolder(folder)) {
                return;
            }
            comp = new SaveAsActivity(this, this.manager.getRegistry(), ctx, p);
        } else if (activity instanceof TransferableActivityParam) {
            TransferableActivityParam p = (TransferableActivityParam)activity;
            comp = new DataTransferActivity((UserNotifier)this, this.manager.getRegistry(), p);
        } else if (activity instanceof ResultsObject) {
            ResultsObject p = (ResultsObject)activity;
            comp = new SaveResultsActivity(this, this.manager.getRegistry(), ctx, p);
        }
        if (comp != null) {
            if (startActivity && register) {
                comp.startActivity();
            }
            this.manager.registerActivity(comp, uiRegister);
            if (startActivity) {
                this.manager.startActivity(false, comp);
            }
        }
    }

    @Override
    public boolean hasRunningActivities() {
        return this.manager.getRunningActivitiesCount() > 0;
    }

    @Override
    public void clearActivities() {
        this.manager.clearActivities();
    }

    @Override
    public void openApplication(ApplicationData data, String path) {
        if (data == null && path == null) {
            return;
        }
        Logger logger = this.manager.getRegistry().getLogger();
        try {
            Object[] commandLineElements = ApplicationData.buildCommand(data, path == null ? null : new File(path));
            logger.info((Object)this, "Executing command & args: " + Arrays.toString(commandLineElements));
            ProcessBuilder builder = new ProcessBuilder((String[])commandLineElements);
            if (((String)commandLineElements[0]).matches(".*Preview\\.app.*")) {
                builder = new ProcessBuilder(new String[]{"open", "-a", "Preview", commandLineElements[1]});
            }
            builder.start();
        }
        catch (Exception e) {
            logger.error((Object)this, e.getMessage());
        }
    }

    @Override
    public void setStatus(Object node) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setStatus(node);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("Done".equals(name) && this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

