/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.jhotdraw.application.ApplicationModel;
import org.jhotdraw.application.DocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationModel
extends AbstractBean
implements ApplicationModel {
    private HashMap<String, Action> actions;
    private String name;
    private String version;
    private String copyright;
    private Class projectClass;
    private String projectClassName;

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setVersion(String newValue) {
        String oldValue = this.version;
        this.version = newValue;
        this.firePropertyChange("version", oldValue, newValue);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setCopyright(String newValue) {
        String oldValue = this.copyright;
        this.copyright = newValue;
        this.firePropertyChange("copyright", oldValue, newValue);
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    public void setProjectClassName(String newValue) {
        String oldValue = this.projectClassName;
        this.projectClassName = newValue;
        this.firePropertyChange("projectClassName", oldValue, newValue);
    }

    public void setProjectClass(Class newValue) {
        Class oldValue = this.projectClass;
        this.projectClass = newValue;
        this.firePropertyChange("projectClass", oldValue, newValue);
    }

    public Class getProjectClass() {
        if (this.projectClass == null && this.projectClassName != null) {
            try {
                this.projectClass = Class.forName(this.projectClassName);
            }
            catch (Exception e) {
                InternalError error = new InternalError("unable to get documentView class");
                error.initCause(e);
                throw error;
            }
        }
        return this.projectClass;
    }

    @Override
    public DocumentView createProject() {
        try {
            return (DocumentView)this.getProjectClass().newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("unable to create documentView");
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public List<JToolBar> createToolBars(DocumentOrientedApplication application, DocumentView p) {
        JButton b;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.application.Labels");
        JToolBar tb = new JToolBar();
        tb.setName(labels.getString("standardToolBarTitle"));
        Action a = this.getAction("File.new");
        if (null != a) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        if (null != (a = this.getAction("File.open"))) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        if (null != (a = this.getAction("File.load"))) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        b = tb.add(this.getAction("File.save"));
        tb.addSeparator();
        b = tb.add(this.getAction("Edit.undo"));
        b.setFocusable(false);
        b = tb.add(this.getAction("Edit.redo"));
        b.setFocusable(false);
        tb.addSeparator();
        b = tb.add(this.getAction("Edit.cut"));
        b.setFocusable(false);
        b = tb.add(this.getAction("Edit.copy"));
        b.setFocusable(false);
        b = tb.add(this.getAction("Edit.paste"));
        b.setFocusable(false);
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        list.add(tb);
        return list;
    }

    @Override
    public List<JMenu> createMenus(DocumentOrientedApplication a, DocumentView p) {
        LinkedList<JMenu> list = new LinkedList<JMenu>();
        list.add(this.createEditMenu(a, p));
        return list;
    }

    protected JMenu createEditMenu(DocumentOrientedApplication a, DocumentView p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.application.Labels");
        JMenu m = new JMenu();
        labels.configureMenu(m, "edit");
        JMenuItem mi = m.add(this.getAction("Edit.undo"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.redo"));
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("Edit.cut"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.copy"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.paste"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.duplicate"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.delete"));
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("Edit.selectAll"));
        mi.setIcon(null);
        if (this.getAction("Edit.find") != null) {
            m.addSeparator();
            m.add(this.getAction("Edit.find"));
        }
        return m;
    }

    @Override
    public void initProject(DocumentOrientedApplication a, DocumentView p) {
    }

    @Override
    public void initApplication(DocumentOrientedApplication a) {
    }

    @Override
    public Action getAction(String id) {
        return this.actions == null ? null : this.actions.get(id);
    }

    @Override
    public void putAction(String id, Action action) {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        if (action == null) {
            this.actions.remove(id);
        } else {
            this.actions.put(id, action);
        }
    }
}

