/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Exception;
import Ice.PluginInitializationException;
import IceInternal.Acceptor;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.StreamSocket;
import IceInternal.Transceiver;
import IceSSL.EndpointI;
import IceSSL.Instance;
import IceSSL.TransceiverI;
import IceUtilInternal.Assert;
import IceUtilInternal.StringUtil;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;

final class AcceptorI
implements Acceptor {
    private EndpointI _endpoint;
    private Instance _instance;
    private String _adapterName;
    private ServerSocketChannel _fd;
    private int _backlog;
    private InetSocketAddress _addr;

    @Override
    public ServerSocketChannel fd() {
        return this._fd;
    }

    @Override
    public void close() {
        if (this._fd != null) {
            Network.closeSocketNoThrow(this._fd);
            this._fd = null;
        }
    }

    @Override
    public IceInternal.EndpointI listen() {
        try {
            this._addr = Network.doBind(this._fd, this._addr, this._backlog);
        }
        catch (Exception ex) {
            this._fd = null;
            throw ex;
        }
        this._endpoint = this._endpoint.endpoint(this);
        return this._endpoint;
    }

    @Override
    public Transceiver accept() {
        if (!this._instance.initialized()) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plug-in is not initialized";
            throw ex;
        }
        StreamSocket stream = new StreamSocket(this._instance, Network.doAccept(this._fd));
        try {
            InetSocketAddress peerAddr = (InetSocketAddress)stream.fd().socket().getRemoteSocketAddress();
            return new TransceiverI(this._instance, this._instance.createSSLEngine(true, peerAddr), stream, this._adapterName, true);
        }
        catch (RuntimeException ex) {
            stream.close();
            throw ex;
        }
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._addr);
    }

    @Override
    public String toDetailedString() {
        StringBuffer s = new StringBuffer("local address = ");
        s.append(this.toString());
        ArrayList<String> intfs = Network.getHostsForEndpointExpand(this._addr.getAddress().getHostAddress(), this._instance.protocolSupport(), true);
        if (!intfs.isEmpty()) {
            s.append("\nlocal interfaces = ");
            s.append(StringUtil.joinString(intfs, ", "));
        }
        return s.toString();
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    AcceptorI(EndpointI endpoint, Instance instance, String adapterName, String host, int port) {
        this._endpoint = endpoint;
        this._instance = instance;
        this._adapterName = adapterName;
        this._backlog = instance.properties().getPropertyAsIntWithDefault("Ice.TCP.Backlog", 511);
        try {
            this._fd = Network.createTcpServerSocket();
            Network.setBlock(this._fd, false);
            Network.setTcpBufSize(this._fd, (ProtocolInstance)this._instance);
            if (!System.getProperty("os.name").startsWith("Windows")) {
                Network.setReuseAddress(this._fd, true);
            }
            this._addr = Network.getAddressForServer(host, port, this._instance.protocolSupport(), this._instance.preferIPv6());
        }
        catch (RuntimeException ex) {
            this._fd = null;
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._fd == null);
        }
        catch (java.lang.Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

