/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.RowFieldCanvas;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellFieldsCanvas;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class WellFieldsView
extends JPanel {
    static final int MAGNIFICATION_UNSCALED_MIN = 1;
    static final int MAGNIFICATION_UNSCALED_MAX = 4;
    static final int DEFAULT_WIDTH = 512;
    static final int DEFAULT_HEIGHT = 512;
    private static final String DEFAULT_WELL_TEXT = "Well: ";
    private static final String DEFAULT_FIELD_TEXT = "Field #";
    private WellsModel model;
    private DataBrowserControl controller;
    private WellFieldsCanvas canvas;
    private List<WellSampleNode> nodes;
    private JLabel selectedNode;
    private JLabel selectedField;
    private double magnification;
    private double magnificationUnscaled;
    private boolean loading = false;
    private JScrollPane pane;

    private void initComponents() {
        this.magnificationUnscaled = 1.0;
        this.selectedField = new JLabel();
        WellSampleNode node = this.model.getSelectedWell();
        this.selectedNode = new JLabel();
        if (node != null && node.isWell()) {
            this.selectedNode.setText(DEFAULT_WELL_TEXT + node.getParentWell().getWellLocation());
        }
        this.nodes = null;
        this.canvas = new RowFieldCanvas(this, this.model);
        this.canvas.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WellSampleNode selection;
                if (WellFieldsCanvas.SELECTION_PROPERTY.equals(evt.getPropertyName())) {
                    List selection2 = (List)evt.getNewValue();
                    ArrayList l = new ArrayList(selection2.size());
                    l.addAll(selection2);
                    WellFieldsView.this.firePropertyChange("selectedDataBrowserNodesDisplay", null, l);
                    WellFieldsView.this.canvas.refreshUI();
                } else if (WellFieldsCanvas.VIEW_PROPERTY.equals(evt.getPropertyName()) && (selection = (WellSampleNode)evt.getNewValue()) != null) {
                    WellFieldsView.this.controller.viewDisplay(selection);
                }
            }
        });
    }

    boolean isSelected(WellSampleNode n) {
        for (WellSampleNode n2 : this.model.getSelectedWells()) {
            if (!n2.isSame(n)) continue;
            return true;
        }
        return false;
    }

    private void buildGUI() {
        this.removeAll();
        this.setBorder(new LineBorder(new Color(99, 130, 191)));
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(UIUtilities.BACKGROUND);
        this.pane = new JScrollPane(this.canvas);
        this.add((Component)this.pane, "Center");
    }

    WellFieldsView(WellsModel model, DataBrowserControl controller, double magnification) {
        this.model = model;
        this.controller = controller;
        this.addPropertyChangeListener(controller);
        this.magnification = magnification;
        this.initComponents();
        this.buildGUI();
    }

    List<WellSampleNode> getNodes() {
        return this.nodes;
    }

    void loadFields(List<WellSampleNode> wells) {
        Dimension thumbDim;
        Dimension dimension = thumbDim = this.magnification > 0.0 ? new Dimension((int)(96.0 * this.magnification), (int)(96.0 * this.magnification)) : null;
        if (wells == null || wells.isEmpty()) {
            this.canvas.clear(Collections.EMPTY_LIST, -1, thumbDim);
        }
        Collections.sort(wells, new Comparator<WellSampleNode>(){

            @Override
            public int compare(WellSampleNode o1, WellSampleNode o2) {
                if (o1.getRow() > o2.getRow()) {
                    return 1;
                }
                if (o1.getRow() < o2.getRow()) {
                    return -1;
                }
                if (o1.getColumn() > o2.getColumn()) {
                    return 1;
                }
                if (o1.getColumn() < o2.getColumn()) {
                    return -1;
                }
                return 0;
            }
        });
        if (this.loading) {
            boolean selectionChanged = false;
            HashSet<Long> ids = new HashSet<Long>();
            for (WellSampleNode wellSampleNode : wells) {
                if (!wellSampleNode.isWell()) continue;
                for (WellSampleNode n : wellSampleNode.getParentWell().getWellSamples()) {
                    WellSampleData d = (WellSampleData)n.getHierarchyObject();
                    ids.add(d.getImage().getId());
                }
            }
            for (WellSampleNode wellSampleNode : this.nodes) {
                WellSampleData d = (WellSampleData)wellSampleNode.getHierarchyObject();
                if (!ids.contains(d.getImage().getId())) {
                    selectionChanged = true;
                    break;
                }
                ids.remove(d.getImage().getId());
            }
            boolean bl = selectionChanged = !ids.isEmpty();
            if (!selectionChanged) {
                return;
            }
        }
        int nFields = 0;
        this.nodes = new ArrayList<WellSampleNode>();
        ArrayList<String> titles = new ArrayList<String>();
        for (WellSampleNode wellSampleNode : wells) {
            if (!wellSampleNode.isWell()) continue;
            this.nodes.addAll(wellSampleNode.getParentWell().getWellSamples());
            nFields = Math.max(nFields, wellSampleNode.getParentWell().getWellSamples().size());
            titles.add(wellSampleNode.getTitle());
        }
        this.canvas.clear(titles, nFields, thumbDim);
        HashSet<Point> toLoad = new HashSet<Point>();
        for (WellSampleNode node : this.nodes) {
            if (node.getThumbnail().isThumbnailLoaded()) continue;
            Point p = new Point(node.getRow(), node.getColumn());
            toLoad.add(p);
        }
        if (!toLoad.isEmpty()) {
            this.loading = true;
            ArrayList<Point> arrayList = new ArrayList<Point>(toLoad.size());
            arrayList.addAll(toLoad);
            this.model.loadFields(arrayList);
            return;
        }
    }

    void updateFieldThumb(WellSampleNode node, boolean complete) {
        this.loading = !complete;
        this.canvas.updateFieldThumb(node);
    }

    void setMagnificationFactor(double factor) {
        this.magnification = factor;
        this.canvas.refreshUI();
    }

    double getMagnification() {
        return this.magnification;
    }

    void setMagnificationUnscaled(double factor) {
        this.magnificationUnscaled = factor;
        this.canvas.refreshUI();
    }

    double getMagnificationUnscaled() {
        return this.magnificationUnscaled;
    }
}

