/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.importer.LoadImporter;
import org.openmicroscopy.shoola.agents.events.treeviewer.ActivitiesEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.BrowserSelectionEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.ChangeUserGroupEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.DisplayModeEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.ExperimenterLoadedDataEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.SaveResultsEvent;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterFactory;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.ReconnectedEvent;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.TaskBar;

public class ImporterAgent
implements Agent,
AgentEventListener {
    private static Registry registry;
    private int browserType;
    private Map<Long, Map<Long, List<TreeImageDisplay>>> objects;
    private long groupId;
    private boolean isMaster;
    private int displayMode = -1;

    public static Registry getRegistry() {
        return registry;
    }

    public static boolean isOfflineImport() {
        Registry context = ImporterAgent.getRegistry();
        Boolean offline = (Boolean)context.lookup("omero.client.import.offline.enabled");
        return offline != null && offline != false;
    }

    public static boolean isMDEImport() {
        Registry context = ImporterAgent.getRegistry();
        Boolean mde = (Boolean)context.lookup("omero.client.import.mde.enabled");
        return mde != null && mde != false;
    }

    public static String getMDEPath() {
        Environment env = (Environment)registry.lookup("/env");
        return env.getMDEConfigPath();
    }

    public static boolean isAdministrator() {
        Boolean b = (Boolean)registry.lookup("/users/administrator");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isImportAs() {
        Boolean b = (Boolean)registry.lookup("/users/sudo");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return ImporterAgent.isAdministrator() && b != false;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static int getScanningDepth() {
        Integer value = (Integer)registry.lookup("/options/ScanningDepth");
        if (value == null || value < 0) {
            return 1;
        }
        return value;
    }

    public static Collection getAvailableUserGroups() {
        return (Collection)registry.lookup("/userGroup/details");
    }

    public static int runAsPlugin() {
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return -1;
        }
        return env.runAsPlugin();
    }

    private int getDefaultBrowser() {
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return 0;
        }
        switch (env.getDefaultHierarchy()) {
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    private void handleLoadImporter(LoadImporter evt) {
        if (evt == null) {
            return;
        }
        long groupId = evt.getGroup();
        Importer importer = ImporterFactory.getImporter(groupId, this.displayMode);
        if (importer != null) {
            int t;
            switch (evt.getType()) {
                case 0: 
                case 1: {
                    t = evt.getType();
                    break;
                }
                default: {
                    t = this.browserType == 0 || this.browserType == 1 ? this.browserType : this.getDefaultBrowser();
                }
            }
            importer.activate(t, evt.getSelectedContainer(), null, evt.getUser());
        }
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        ImporterFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleReconnectedEvent(ReconnectedEvent evt) {
        if (evt == null) {
            return;
        }
        ImporterFactory.onReconnected();
        if (this.isMaster) {
            Importer importer = ImporterFactory.getImporter(ImporterAgent.getUserDetails().getGroupId(), true, this.displayMode);
            importer.activate(this.browserType, null, null, importer.getImportFor());
        }
    }

    private List<Object> handleContainers(long groupId) {
        if (this.objects == null) {
            return null;
        }
        Map<Long, List<TreeImageDisplay>> data = this.objects.get(groupId);
        if (data == null) {
            return null;
        }
        List<TreeImageDisplay> l = data.get(ImporterAgent.getUserDetails().getId());
        if (l == null) {
            return null;
        }
        Iterator<TreeImageDisplay> i = l.iterator();
        ArrayList<Object> values = new ArrayList<Object>();
        while (i.hasNext()) {
            values.add(i.next().getUserObject());
        }
        return values;
    }

    private void handleExperimenterLoadedDataEvent(ExperimenterLoadedDataEvent evt) {
        if (evt == null) {
            return;
        }
        Map<Long, Map<Long, List<TreeImageDisplay>>> map = evt.getData();
        this.objects = map;
        if (!ImporterFactory.doesImporterExist()) {
            return;
        }
        Importer importer = ImporterFactory.getImporter(this.groupId, this.displayMode);
        if (importer == null || map == null || map.size() == 0) {
            return;
        }
        GroupData group = importer.getSelectedGroup();
        if (group == null) {
            return;
        }
        List<Object> l = this.handleContainers(group.getId());
        if (CollectionUtils.isEmpty(l)) {
            return;
        }
        importer.setContainers(l, true, false, this.browserType, importer.getImportFor());
    }

    private void handleDisplayModeEvent(DisplayModeEvent evt) {
        if (evt == null) {
            return;
        }
        this.displayMode = evt.getDisplayMode();
        ImporterFactory.setDiplayMode(this.displayMode);
    }

    private void handleActivitiesEvent(ActivitiesEvent evt) {
        if (evt == null) {
            return;
        }
        ImporterFactory.setDiplayMode(this.displayMode);
    }

    private void handleSaveResultsEvent(SaveResultsEvent evt) {
        if (evt == null) {
            return;
        }
        Importer importer = ImporterFactory.getImporter(this.groupId, this.displayMode);
        importer.importResults(evt.getObject(), evt.isFirstImport());
    }

    private void register() {
        String description = "Open the Importer.";
        TaskBar tb = registry.getTaskBar();
        IconManager icons = IconManager.getInstance();
        JButton b = new JButton(icons.getIcon(1));
        b.setToolTipText(description);
        Boolean value = (Boolean)registry.lookup("canCreate");
        b.setEnabled(value);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventBus bus = registry.getEventBus();
                ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
                if (exp == null) {
                    return;
                }
                GroupData gp = null;
                try {
                    gp = exp.getDefaultGroup();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long id = -1L;
                if (gp != null) {
                    id = gp.getId();
                }
                if (ImporterAgent.this.groupId == -1L) {
                    ImporterAgent.this.groupId = id;
                }
                LoadImporter event = new LoadImporter(null, ImporterAgent.this.browserType);
                event.setGroup(ImporterAgent.this.groupId);
                event.setObjects(ImporterAgent.this.objects);
                bus.post(event);
            }
        };
        b.addActionListener(l);
        tb.addToToolBar(201, b);
        JMenuItem item = new JMenuItem(icons.getIcon(1));
        item.setText("Import...");
        item.setToolTipText(description);
        item.addActionListener(l);
        item.setEnabled(value);
        tb.addToMenu(2, item);
    }

    @Override
    public void activate(boolean master) {
        this.isMaster = master;
        if (master) {
            Importer importer;
            this.isMaster = master;
            ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
            if (exp == null) {
                return;
            }
            GroupData gp = null;
            try {
                gp = exp.getDefaultGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long id = -1L;
            if (gp != null) {
                id = gp.getId();
            }
            if ((importer = ImporterFactory.getImporter(id, true, this.displayMode)) != null) {
                Environment env = (Environment)registry.lookup("/env");
                int type = 0;
                if (env != null) {
                    switch (env.getDefaultHierarchy()) {
                        default: {
                            type = 0;
                            break;
                        }
                        case 1: {
                            type = 1;
                        }
                    }
                }
                importer.activate(type, null, null, importer.getImportFor());
            }
        }
    }

    @Override
    public void terminate() {
        Environment env = (Environment)registry.lookup("/env");
        if (env.isRunAsPlugin()) {
            ImporterFactory.terminate();
        }
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, LoadImporter.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, ReconnectedEvent.class);
        bus.register((AgentEventListener)this, BrowserSelectionEvent.class);
        bus.register((AgentEventListener)this, ExperimenterLoadedDataEvent.class);
        bus.register((AgentEventListener)this, ChangeUserGroupEvent.class);
        bus.register((AgentEventListener)this, DisplayModeEvent.class);
        bus.register((AgentEventListener)this, ActivitiesEvent.class);
        bus.register((AgentEventListener)this, SaveResultsEvent.class);
        this.browserType = this.getDefaultBrowser();
        this.groupId = -1L;
        this.register();
    }

    @Override
    public boolean canTerminate() {
        if (!ImporterFactory.doesImporterExist()) {
            return true;
        }
        Importer importer = ImporterFactory.getImporter(this.groupId, this.displayMode);
        if (importer == null) {
            return true;
        }
        return !importer.hasOnGoingUpload();
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        return null;
    }

    @Override
    public void save(List<Object> instances) {
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof LoadImporter) {
            this.handleLoadImporter((LoadImporter)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof ReconnectedEvent) {
            this.handleReconnectedEvent((ReconnectedEvent)e);
        } else if (e instanceof BrowserSelectionEvent) {
            BrowserSelectionEvent evt = (BrowserSelectionEvent)e;
            this.browserType = evt.getType();
        } else if (e instanceof ExperimenterLoadedDataEvent) {
            this.handleExperimenterLoadedDataEvent((ExperimenterLoadedDataEvent)e);
        } else if (e instanceof ChangeUserGroupEvent) {
            ChangeUserGroupEvent evt = (ChangeUserGroupEvent)e;
            this.groupId = evt.getGroupID();
        } else if (e instanceof DisplayModeEvent) {
            this.handleDisplayModeEvent((DisplayModeEvent)e);
        } else if (e instanceof ActivitiesEvent) {
            this.handleActivitiesEvent((ActivitiesEvent)e);
        } else if (e instanceof SaveResultsEvent) {
            this.handleSaveResultsEvent((SaveResultsEvent)e);
        }
    }

    public static boolean canCreate() {
        Boolean b = (Boolean)registry.lookup("canCreate");
        return b;
    }
}

