/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.model.ChannelData;
import omero.log.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnalysisStatsWrapper;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStatsSimple;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.graphutils.HistogramPlot;
import org.openmicroscopy.shoola.util.ui.graphutils.LinePlot;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

public class GraphPane
extends JPanel
implements TabPaneInterface,
PropertyChangeListener,
ChangeListener {
    static final int READY = 1;
    static final int ANALYSING = 0;
    public static final int INDEX = 3;
    private static final String NAME = "Graph Pane";
    private static final Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private Map ROIStats;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private JPanel mainPanel;
    private Map<Coord3D, Map<AnalysisStatsWrapper.StatsType, Map>> shapeStatsList;
    private Map<Coord3D, Map<Integer, ROIShapeStatsSimple>> pixelStats;
    private Map<Coord3D, ROIShape> shapeMap;
    private List<String> channelName;
    private List<Color> channelColour;
    private Coord3D coord;
    private LinePlot lineProfileChart;
    private HistogramPlot histogramChart;
    private MeasurementViewerUI view;
    private ROIShape shape;
    private JButton export;

    @Override
    public int getIndex() {
        return 3;
    }

    private boolean lineProfileFigure(ROIShape shape) {
        MeasureBezierFigure fig;
        ROIFigure f = shape.getFigure();
        if (f instanceof MeasureLineFigure) {
            return true;
        }
        return f instanceof MeasureBezierFigure && !(fig = (MeasureBezierFigure)f).isClosed();
    }

    private double channelMinValue() {
        Map channels = this.model.getActiveChannels();
        Iterator i = channels.entrySet().iterator();
        double value = Double.MAX_VALUE;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            int channel = (Integer)entry.getKey();
            value = Math.min(value, this.model.getMetadata(channel).getGlobalMin());
        }
        return value;
    }

    private double channelMaxValue() {
        Map channels = this.model.getActiveChannels();
        Iterator i = channels.entrySet().iterator();
        double value = Double.MIN_VALUE;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            int channel = (Integer)entry.getKey();
            value = Math.max(value, this.model.getMetadata(channel).getGlobalMax());
        }
        return value;
    }

    private void handleSliderReleased() {
        int newT;
        int newZ = this.zSlider.getValue() - 1;
        if (this.checkPlane(newZ, newT = this.tSlider.getValue() - 1)) {
            SelectPlane evt = new SelectPlane(this.model.getPixelsID(), this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
            MeasurementAgent.getRegistry().getEventBus().post(evt);
        }
    }

    private boolean checkPlane(int z, int t) {
        if (z < 0 || this.model.getNumZSections() <= z) {
            return false;
        }
        return t >= 0 && this.model.getNumTimePoints() > t;
    }

    public void saveGraph(File file, int type) {
        try {
            if (this.lineProfileChart != null) {
                this.lineProfileChart.saveAs(file, type);
            } else {
                this.histogramChart.saveAs(file, type);
            }
        }
        catch (Exception e) {
            Logger logger = MeasurementAgent.getRegistry().getLogger();
            logger.error((Object)this, "Cannot save the graph: " + e.toString());
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save Results", "An error occurred while saving the graph.\nPlease try again.");
        }
    }

    private void initComponents() {
        this.export = new JButton(this.controller.getAction(MeasurementViewerControl.EXPORT_GRAPH));
        this.zSlider = new OneKnobSlider();
        this.zSlider.setOrientation(1);
        this.zSlider.setPaintTicks(false);
        this.zSlider.setPaintLabels(false);
        this.zSlider.setMajorTickSpacing(1);
        this.zSlider.setShowArrows(true);
        this.zSlider.setVisible(false);
        this.zSlider.setEndLabel("Z");
        this.zSlider.setShowEndLabel(true);
        this.tSlider = new OneKnobSlider();
        this.tSlider.setPaintTicks(false);
        this.tSlider.setPaintLabels(false);
        this.tSlider.setMajorTickSpacing(1);
        this.tSlider.setSnapToTicks(true);
        this.tSlider.setShowArrows(true);
        this.tSlider.setVisible(false);
        this.tSlider.setEndLabel("T");
        this.tSlider.setShowEndLabel(true);
        this.zSlider.addPropertyChangeListener(this);
        this.tSlider.addPropertyChangeListener(this);
        this.zSlider.addChangeListener(this);
        this.tSlider.addChangeListener(this);
        this.mainPanel = new JPanel();
    }

    private void buildGUI() {
        this.buildHistogramNoSelection();
        this.setLayout(new BoxLayout(this, 1));
        JPanel centrePanel = new JPanel();
        centrePanel.setLayout(new BoxLayout(centrePanel, 0));
        centrePanel.add(this.zSlider);
        centrePanel.add(Box.createHorizontalStrut(5));
        centrePanel.add(this.mainPanel);
        centrePanel.add(this.export);
        this.add(centrePanel);
        this.add(this.tSlider);
    }

    private void buildHistogramNoSelection() {
        this.mainPanel.removeAll();
        this.histogramChart = this.drawHistogram("Histogram", new ArrayList<String>(), new ArrayList<double[]>(), new ArrayList<Color>(), 1001);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.histogramChart.getChart(Collections.singletonList(this.controller.getAction(MeasurementViewerControl.EXPORT_GRAPH))), "Center");
    }

    private LinePlot drawLineplot(String title, List<String> channelNames, List<double[][]> data, List<Color> channelColours) {
        if (channelNames.size() == 0 || data.size() == 0 || channelColours.size() == 0) {
            return null;
        }
        if (channelNames.size() != channelColours.size() || channelNames.size() != data.size()) {
            return null;
        }
        LinePlot plot = new LinePlot(title, channelNames, data, channelColours, this.channelMinValue(), this.channelMaxValue());
        plot.setYAxisName("Intensity");
        plot.setXAxisName("Points");
        return plot;
    }

    private HistogramPlot drawHistogram(String title, List<String> channelNames, List<double[]> data, List<Color> channelColours, int bins) {
        HistogramPlot plot = CollectionUtils.isNotEmpty(data) ? new HistogramPlot(title, channelNames, data, channelColours, bins, this.channelMinValue(), this.channelMaxValue()) : new HistogramPlot(title, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, bins, 0.0, 1.0);
        plot.setXAxisName("Intensity");
        plot.setYAxisName("Frequency");
        return plot;
    }

    private void buildGraphsAndDisplay() {
        this.coord = new Coord3D(this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
        Map<Integer, ROIShapeStatsSimple> data = this.pixelStats.get(this.coord);
        if (data == null) {
            return;
        }
        this.shape = this.shapeMap.get(this.coord);
        ArrayList<double[]> channelData = new ArrayList<double[]>();
        ArrayList<double[][]> channelXYData = new ArrayList<double[][]>();
        this.channelName.clear();
        this.channelColour.clear();
        channelData.clear();
        List<ChannelData> metadata = this.model.getMetadata();
        for (ChannelData cData : metadata) {
            double[] values;
            Color c;
            int channel = cData.getIndex();
            if (!this.model.isChannelActive(channel)) continue;
            cData = this.model.getMetadata(channel);
            if (cData != null) {
                this.channelName.add(cData.getChannelLabeling());
            }
            if (UIUtilities.isSameColors(c = this.model.getActiveChannelColor(channel), Color.white, false)) {
                c = DEFAULT_COLOR;
            }
            this.channelColour.add(c);
            ROIShapeStatsSimple stats = data.get(channel);
            if (stats == null || (values = stats.getValues()) == null || values.length == 0) continue;
            channelData.add(values);
            if (!this.lineProfileFigure(this.shape)) continue;
            double[][] dataXY = new double[2][values.length];
            for (int i = 0; i < values.length; ++i) {
                dataXY[0][i] = i;
                dataXY[1][i] = values[i];
            }
            channelXYData.add(dataXY);
        }
        this.mainPanel.removeAll();
        if (channelData.size() == 0) {
            this.buildHistogramNoSelection();
            return;
        }
        this.lineProfileChart = null;
        this.histogramChart = null;
        if (this.lineProfileFigure(this.shape)) {
            this.lineProfileChart = this.drawLineplot("Line Profile", this.channelName, channelXYData, this.channelColour);
        }
        this.histogramChart = this.drawHistogram("Histogram", this.channelName, channelData, this.channelColour, 1001);
        if (this.lineProfileChart == null && this.histogramChart != null) {
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.histogramChart.getChart(Collections.singletonList(this.controller.getAction(MeasurementViewerControl.EXPORT_GRAPH))), "Center");
        }
        if (this.lineProfileChart != null && this.histogramChart != null) {
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            this.mainPanel.add(this.lineProfileChart.getChart(Collections.singletonList(this.controller.getAction(MeasurementViewerControl.EXPORT_GRAPH))));
            this.mainPanel.add(this.histogramChart.getChart(Collections.singletonList(this.controller.getAction(MeasurementViewerControl.EXPORT_GRAPH))));
        }
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private void formatPlane() {
        if (!this.zSlider.isVisible() && !this.tSlider.isVisible()) {
            this.view.setPlaneStatus("");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.zSlider.isVisible()) {
            buffer.append("Z=" + this.zSlider.getValue() + " ");
        }
        if (this.tSlider.isVisible()) {
            buffer.append("T=" + this.tSlider.getValue());
        }
        this.view.setPlaneStatus(buffer.toString());
    }

    GraphPane(MeasurementViewerUI view, MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.view = view;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(26);
    }

    void clearData() {
        this.mainPanel.removeAll();
        if (this.zSlider != null) {
            this.zSlider.setEnabled(false);
        }
        if (this.tSlider != null) {
            this.tSlider.setEnabled(false);
        }
    }

    void displayAnalysisResults() {
        this.ROIStats = this.model.getAnalysisResults();
        if (this.ROIStats == null || this.ROIStats.size() == 0) {
            this.buildHistogramNoSelection();
            return;
        }
        this.shapeStatsList = new HashMap<Coord3D, Map<AnalysisStatsWrapper.StatsType, Map>>();
        this.pixelStats = new HashMap<Coord3D, Map<Integer, ROIShapeStatsSimple>>();
        this.shapeMap = new HashMap<Coord3D, ROIShape>();
        this.channelName = new ArrayList<String>();
        this.channelColour = new ArrayList<Color>();
        Iterator i = this.ROIStats.entrySet().iterator();
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minT = Integer.MAX_VALUE;
        int maxT = Integer.MIN_VALUE;
        int t = this.model.getDefaultT();
        int z = this.model.getDefaultZ();
        boolean hasData = false;
        HashSet<Figure> statsMissingFigures = new HashSet<Figure>();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.shape = (ROIShape)entry.getKey();
            Coord3D c3D = this.shape.getCoord3D();
            int cT = c3D.getTimePoint();
            int cZ = c3D.getZSection();
            if (cZ == z) {
                minT = Math.min(minT, cT);
                maxT = Math.max(maxT, cT);
            }
            if (cT == t) {
                minZ = Math.min(minZ, cZ);
                maxZ = Math.max(maxZ, cZ);
            }
            this.shapeMap.put(c3D, this.shape);
            if (this.shape.getFigure() instanceof MeasureTextFigure) {
                return;
            }
            Map<AnalysisStatsWrapper.StatsType, Map> shapeStats = AnalysisStatsWrapper.convertStats((Map)entry.getValue());
            if (cT == t && cZ == z) {
                if (shapeStats != null) {
                    hasData = true;
                } else {
                    statsMissingFigures.add(this.shape.getFigure());
                }
            }
            if (shapeStats == null) continue;
            this.shapeStatsList.put(c3D, shapeStats);
            Map data = shapeStats.get((Object)AnalysisStatsWrapper.StatsType.PIXELDATA);
            this.pixelStats.put(c3D, data);
        }
        if (!hasData) {
            if (!statsMissingFigures.isEmpty()) {
                this.controller.analyseFigures(statsMissingFigures);
            }
            this.buildHistogramNoSelection();
            return;
        }
        ++minT;
        this.zSlider.removeChangeListener(this);
        this.tSlider.removeChangeListener(this);
        this.zSlider.setMaximum(++maxZ);
        this.zSlider.setMinimum(++minZ);
        this.tSlider.setMaximum(++maxT);
        this.tSlider.setMinimum(minT);
        this.zSlider.setVisible(maxZ != minZ);
        this.tSlider.setVisible(maxT != minT);
        this.tSlider.setValue(this.model.getCurrentView().getTimePoint() + 1);
        this.zSlider.setValue(this.model.getCurrentView().getZSection() + 1);
        this.zSlider.addChangeListener(this);
        this.tSlider.addChangeListener(this);
        this.formatPlane();
        this.buildGraphsAndDisplay();
    }

    void onAnalysed(boolean analyse) {
        this.zSlider.setEnabled(!analyse);
        this.tSlider.setEnabled(!analyse);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.zSlider || src == this.tSlider) {
            this.formatPlane();
            this.handleSliderReleased();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("oneKnobReleasedProperty".equals(name)) {
            this.handleSliderReleased();
        }
    }
}

