/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.openmicroscopy.shoola.env.data.model.appdata.ApplicationDataExtractor;
import org.openmicroscopy.shoola.env.data.model.appdata.LinuxApplicationDataExtractor;
import org.openmicroscopy.shoola.env.data.model.appdata.MacApplicationDataExtractor;
import org.openmicroscopy.shoola.env.data.model.appdata.WindowsApplicationDataExtractor;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ApplicationData {
    private static ApplicationDataExtractor extractor;
    private File file;
    private String applicationName;
    private Icon applicationIcon;
    private String executable;
    private List<String> commands;

    public static String getDefaultLocation() {
        return extractor.getDefaultAppDirectory();
    }

    public ApplicationData(File file) throws Exception {
        this.file = file;
        this.commands = new ArrayList<String>();
        if (!file.exists()) {
            throw new Exception("Application does not exists @ " + file.getAbsolutePath());
        }
        try {
            ApplicationData data = extractor.extractAppData(file);
            this.applicationName = data.applicationName;
            this.executable = data.executable;
            this.applicationIcon = data.applicationIcon;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ApplicationData(Icon icon, String applicationName, String executablePath) {
        this.applicationIcon = icon;
        this.applicationName = applicationName;
        this.executable = executablePath;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Icon getApplicationIcon() {
        return this.applicationIcon;
    }

    public String getApplicationPath() {
        return this.file.getAbsolutePath();
    }

    public Iterable<String> getCommandLineArguments() {
        return this.commands;
    }

    public void setCommandLineArguments(List<String> commands) {
        this.commands = commands;
    }

    public String toString() {
        return this.applicationName;
    }

    public static String[] buildCommand(ApplicationData data, File file) throws MalformedURLException {
        if (data == null && file != null) {
            return extractor.getDefaultOpenCommandFor(file.toURI().toURL());
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(data.executable);
        for (String commandArg : data.getCommandLineArguments()) {
            commandLine.add(commandArg);
        }
        if (file != null) {
            commandLine.add(file.getAbsolutePath());
        }
        return commandLine.toArray(new String[0]);
    }

    static {
        if (UIUtilities.isWindowsOS()) {
            extractor = new WindowsApplicationDataExtractor();
        } else if (UIUtilities.isMacOS()) {
            extractor = new MacApplicationDataExtractor();
        } else if (UIUtilities.isLinuxOS()) {
            extractor = new LinuxApplicationDataExtractor();
        }
    }
}

