/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ArchivedLoader
extends UserNotifierLoader {
    private CallHandle handle;
    private List<DataObject> objects;
    private File file;
    private boolean cancelled;
    private boolean override;
    private boolean zip = false;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to download the image", message, ex);
    }

    public ArchivedLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, List<DataObject> objects, File file, boolean override, boolean zip, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (objects == null) {
            throw new IllegalArgumentException("No objects provided.");
        }
        this.objects = objects;
        this.file = file;
        this.override = override;
        this.zip = zip;
    }

    @Override
    public void load() {
        if (CollectionUtils.isEmpty(this.objects)) {
            return;
        }
        this.handle = this.mhView.loadArchivedImage(this.ctx, this.objects, this.file, this.override, this.zip, this);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.handle != null) {
            this.handle.cancel();
        }
    }

    @Override
    public void handleNullResult() {
        this.activity.endActivity(new ArrayList());
    }

    @Override
    public void handleResult(Object result) {
        if (result == null && !this.cancelled) {
            this.handleNullResult();
        } else {
            Map m = (Map)result;
            List l = (List)m.get(false);
            if (!CollectionUtils.isEmpty((Collection)l)) {
                if (!this.cancelled) {
                    this.onException("Missing " + l.size() + " file(s) composing the image", null);
                }
            } else {
                List files = (List)m.get(true);
                if (this.cancelled) {
                    for (File f : files) {
                        if (f.isDirectory()) {
                            try {
                                FileUtils.deleteDirectory((File)f);
                            }
                            catch (Exception e) {
                                this.registry.getLogger().error((Object)this, "Cannot delete the directory");
                            }
                            continue;
                        }
                        f.delete();
                    }
                } else {
                    this.activity.endActivity(files);
                }
            }
        }
    }
}

