/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class ExcelFilter
extends CustomizedFileFilter {
    public static final String EXCEL = "xls";
    public static final String EXCEL_X = "xlsx";
    public static final String EXCEL_M = "xlsm";
    public static final String EXCEL_TX = "xltx";
    public static final String EXCEL_TM = "xltm";
    public static final String[] extensions = new String[5];
    private static final String description;

    @Override
    public String getMIMEType() {
        return "application/vnd.ms-excel";
    }

    @Override
    public String getExtension() {
        return EXCEL;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    @Override
    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        ExcelFilter.extensions[0] = EXCEL;
        ExcelFilter.extensions[1] = EXCEL_X;
        ExcelFilter.extensions[2] = EXCEL_M;
        ExcelFilter.extensions[3] = EXCEL_TX;
        ExcelFilter.extensions[4] = EXCEL_TM;
        StringBuffer s = new StringBuffer();
        s.append("Microsoft Excel (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

