/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class JPEGFilter
extends CustomizedFileFilter {
    public static final String MIMETYPE = "image/jpeg";
    public static final String JPEG = "jpeg";
    public static final String JPG = "jpg";
    public static final String JPE = "jpe";
    public static final String[] extensions = new String[3];
    private static final String description;

    @Override
    public String getMIMEType() {
        return MIMETYPE;
    }

    @Override
    public String getExtension() {
        return JPEG;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    @Override
    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        JPEGFilter.extensions[0] = JPEG;
        JPEGFilter.extensions[1] = JPG;
        JPEGFilter.extensions[2] = JPE;
        StringBuffer s = new StringBuffer();
        s.append("JPEG (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

