/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.model.EllipseData;
import omero.gateway.model.LineData;
import omero.gateway.model.MaskData;
import omero.gateway.model.PointData;
import omero.gateway.model.PolygonData;
import omero.gateway.model.PolylineData;
import omero.gateway.model.ROIData;
import omero.gateway.model.RectangleData;
import omero.gateway.model.ShapeData;
import omero.gateway.model.ShapeSettingsData;
import omero.gateway.model.TextData;
import omero.model.AffineTransform;
import omero.model.Length;
import omero.model.enums.UnitsLength;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.Cap;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureMaskFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

class InputServerStrategy {
    public static final AttributeKey<java.awt.geom.AffineTransform> TRANSFORM = new AttributeKey("transform", null, true);
    private static final Map<AttributeKey, Object> DEFAULT_ATTRIBUTES = new HashMap<AttributeKey, Object>();
    private List<ROI> roiList = new ArrayList<ROI>();
    private ROIComponent component;

    private void addMissingAttributes(ROIFigure figure) {
        Map attributes = figure.getAttributes();
        for (AttributeKey key : DEFAULT_ATTRIBUTES.keySet()) {
            if (attributes.containsKey(key)) continue;
            key.set((Figure)figure, DEFAULT_ATTRIBUTES.get(key));
        }
    }

    private ROI createROI(ROIData roi, long userID) throws NoSuchROIException, ROICreationException {
        long id = roi.getId();
        boolean edit = roi.canEdit();
        if (edit) {
            edit = roi.getOwner().getId() == userID;
        }
        ROI newROI = this.component.createROI(id, id <= 0L, edit, roi.canDelete(), roi.canAnnotate(), roi.getFolders());
        newROI.setOwnerID(roi.getOwner().getId());
        Iterator<List<ShapeData>> i = roi.getIterator();
        while (i.hasNext()) {
            List<ShapeData> list = i.next();
            for (ShapeData shapeData : list) {
                ROIShape shape = this.createROIShape(shapeData, newROI, userID);
                if (shape == null) continue;
                shape.getFigure().setMeasurementUnits(this.component.getMeasurementUnits());
                Coord3D c = shape.getCoord3D();
                if (c == null || this.component.containsShape(newROI.getID(), c)) continue;
                this.component.addShape(newROI.getID(), c, shape);
            }
        }
        return newROI;
    }

    private ROIShape createROIShape(ShapeData data, ROI roi, long userID) {
        int z = data.getZ();
        int t = data.getT();
        Coord3D coord = new Coord3D(z, t);
        ROIFigure fig = this.createROIFigure(data);
        fig.setReadOnly(data.isReadOnly());
        long id = data.getOwner().getId();
        if (id >= 0L) {
            fig.setInteractable(id == userID);
        }
        try {
            coord.setChannel(data.getC());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addMissingAttributes(fig);
        ROIShape shape = new ROIShape(roi, coord, fig, fig.getBounds());
        shape.setROIShapeID(data.getId());
        shape.setData(data);
        return shape;
    }

    private ROIFigure createROIFigure(ShapeData shape) {
        if (shape instanceof RectangleData) {
            return this.createRectangleFigure((RectangleData)shape);
        }
        if (shape instanceof EllipseData) {
            return this.createEllipseFigure((EllipseData)shape);
        }
        if (shape instanceof LineData) {
            return this.createLineFigure((LineData)shape);
        }
        if (shape instanceof PointData) {
            return this.createPointFigure((PointData)shape);
        }
        if (shape instanceof PolylineData) {
            return this.createPolyOrlineFigure((PolylineData)shape);
        }
        if (shape instanceof PolygonData) {
            return this.createPolygonFigure((PolygonData)shape);
        }
        if (shape instanceof MaskData) {
            return this.createMaskFigure((MaskData)shape);
        }
        if (shape instanceof TextData) {
            return this.createTextFigure((TextData)shape);
        }
        return null;
    }

    private MeasureEllipseFigure createEllipseFigure(EllipseData data) {
        double x = data.getX();
        double y = data.getY();
        double radiusx = data.getRadiusX();
        double radiusy = data.getRadiusY();
        double x0 = x - radiusx;
        double y0 = y - radiusy;
        double width = radiusx * 2.0;
        double height = radiusy * 2.0;
        MeasureEllipseFigure fig = new MeasureEllipseFigure(data.getText(), x0, y0, width, height, data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        fig.setEllipse(x0, y0, width, height);
        fig.setText(data.getText());
        this.addShapeSettings(fig, data.getShapeSettings());
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        return fig;
    }

    private MeasurePointFigure createPointFigure(PointData data) {
        double r = 11.0;
        double x = data.getX() - r;
        double y = data.getY() - r;
        MeasurePointFigure fig = new MeasurePointFigure(data.getText(), x, y, 22.0, 22.0, data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        this.addShapeSettings(fig, data.getShapeSettings());
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        return fig;
    }

    private MeasureTextFigure createTextFigure(TextData data) {
        double x = data.getX();
        double y = data.getY();
        MeasureTextFigure fig = new MeasureTextFigure(x, y, data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        fig.setText(data.getText());
        this.addShapeSettings(fig, data.getShapeSettings());
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        return fig;
    }

    private MeasureRectangleFigure createRectangleFigure(RectangleData data) {
        double x = data.getX();
        double y = data.getY();
        double width = data.getWidth();
        double height = data.getHeight();
        MeasureRectangleFigure fig = new MeasureRectangleFigure(x, y, width, height, data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        return fig;
    }

    private MeasureMaskFigure createMaskFigure(MaskData data) {
        double x = data.getX();
        double y = data.getY();
        double width = data.getWidth();
        double height = data.getHeight();
        BufferedImage mask = data.getMaskAsBufferedImage();
        MeasureMaskFigure fig = new MeasureMaskFigure(x, y, width, height, mask, data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        fig.setVisible(true);
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        return fig;
    }

    private MeasureLineFigure createLineFigure(LineData data) {
        double x1 = data.getX1();
        double y1 = data.getY1();
        double x2 = data.getX2();
        double y2 = data.getY2();
        MeasureLineFigure fig = new MeasureLineFigure(data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        fig.removeAllNodes();
        fig.addNode(new BezierPath.Node(x1, y1));
        fig.addNode(new BezierPath.Node(x2, y2));
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        return fig;
    }

    private MeasureBezierFigure createPolygonFigure(PolygonData data) {
        MeasureBezierFigure fig = new MeasureBezierFigure(false, data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        List<Point2D.Double> points = data.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            fig.addNode(new BezierPath.Node(i, points.get(i), points.get(i), points.get(i)));
        }
        this.addShapeSettings(fig, data.getShapeSettings());
        String text = data.getText();
        if (text == null || text.trim().length() == 0) {
            text = "";
        }
        fig.setText(text);
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        fig.setClosed(true);
        return fig;
    }

    private ROIFigure createPolyOrlineFigure(PolylineData data) {
        return this.createPolylineFromPolylineFigure(data);
    }

    private ROIFigure createPolylineFromPolylineFigure(PolylineData data) {
        List<Point2D.Double> points = data.getPoints();
        MeasureBezierFigure fig = new MeasureBezierFigure(false, data.isReadOnly(), data.isClientObject(), data.canEdit(), data.canDelete(), data.canAnnotate());
        for (int i = 0; i < points.size(); ++i) {
            fig.addNode(new BezierPath.Node(i, points.get(i), points.get(i), points.get(i)));
        }
        this.addShapeSettings(fig, data.getShapeSettings());
        String text = data.getText();
        if (text == null || text.trim().length() == 0) {
            text = "";
        }
        fig.setText(text);
        TRANSFORM.set((Figure)fig, (Object)InputServerStrategy.toTransform(data.getTransform()));
        return fig;
    }

    private void addShapeSettings(ROIFigure figure, ShapeSettingsData data) {
        Cap c;
        Object dec;
        Double value = 1.0;
        try {
            Length l = data.getStrokeWidth(UnitsLength.PIXEL);
            if (l != null && l.getValue() >= 1.0) {
                value = l.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AttributeKeys.STROKE_WIDTH.set((Figure)figure, (Object)value);
        AttributeKeys.STROKE_COLOR.set((Figure)figure, (Object)data.getStroke());
        AttributeKeys.FILL_COLOR.set((Figure)figure, (Object)data.getFill());
        Font f = data.getFont();
        AttributeKeys.FONT_FACE.set((Figure)figure, (Object)f);
        AttributeKeys.FONT_SIZE.set((Figure)figure, (Object)f.getSize());
        AttributeKeys.FONT_ITALIC.set((Figure)figure, (Object)data.isFontItalic());
        AttributeKeys.FONT_BOLD.set((Figure)figure, (Object)data.isFontBold());
        AttributeKeys.TEXT_COLOR.set((Figure)figure, (Object)data.getStroke());
        if (CommonsLangUtils.isNotBlank(data.getMarkerStart())) {
            dec = null;
            c = Cap.findByValue(data.getMarkerStart());
            if (c != null) {
                dec = c.newLineDecorationInstance();
            }
            MeasurementAttributes.START_DECORATION.set((Figure)figure, dec);
        }
        if (CommonsLangUtils.isNotBlank(data.getMarkerEnd())) {
            dec = null;
            c = Cap.findByValue(data.getMarkerEnd());
            if (c != null) {
                dec = c.newLineDecorationInstance();
            }
            MeasurementAttributes.END_DECORATION.set((Figure)figure, dec);
        }
    }

    private static java.awt.geom.AffineTransform toTransform(AffineTransform omeroTransform) {
        if (omeroTransform == null || omeroTransform.getA00() == null || omeroTransform.getA01() == null || omeroTransform.getA02() == null || omeroTransform.getA10() == null || omeroTransform.getA11() == null || omeroTransform.getA12() == null) {
            return new java.awt.geom.AffineTransform();
        }
        return new java.awt.geom.AffineTransform(omeroTransform.getA00().getValue(), omeroTransform.getA10().getValue(), omeroTransform.getA01().getValue(), omeroTransform.getA11().getValue(), omeroTransform.getA02().getValue(), omeroTransform.getA12().getValue());
    }

    InputServerStrategy() {
    }

    List<ROI> readROI(Collection rois, ROIComponent component, long userID) throws ROICreationException, NoSuchROIException {
        if (component == null) {
            throw new IllegalArgumentException("No component.");
        }
        this.component = component;
        for (Object o : rois) {
            if (!(o instanceof ROIData)) continue;
            ROIData roi = (ROIData)o;
            this.roiList.add(this.createROI(roi, userID));
        }
        return this.roiList;
    }

    static {
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.FILL_COLOR, ShapeSettingsData.DEFAULT_FILL_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.STROKE_COLOR, ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.TEXT_COLOR, ShapeSettingsData.DEFAULT_FILL_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.FONT_SIZE, 12);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.STROKE_WIDTH, 1.0);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.TEXT, "");
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.MEASUREMENTTEXT_COLOUR, ShapeSettingsData.DEFAULT_FILL_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.SHOWMEASUREMENT, false);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.SHOWTEXT, false);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.SCALE_PROPORTIONALLY, false);
    }
}

