/*
 * Decompiled with CFR 0.152.
 */
package ome.util.checksum;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.nio.ByteBuffer;
import ome.util.checksum.AbstractChecksumProvider;
import ome.util.checksum.ChecksumProvider;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AbstractChecksumProviderTest
extends MockObjectTestCase {
    private Mock mockHashFunction;
    private Mock mockHasher;
    private AbstractChecksumProvider abstractChecksumProvider;

    @BeforeClass
    public void setUp() throws Exception {
        this.mockHashFunction = this.mock(HashFunction.class);
        this.mockHasher = this.mock(Hasher.class);
    }

    @Test
    public void testAbstractChecksumProviderCtor() {
        this.mockHashFunction.expects(this.once()).method("newHasher").withNoArguments().will(this.returnValue(this.mockHasher.proxy()));
        this.abstractChecksumProvider = new AbstractChecksumProvider((HashFunction)this.mockHashFunction.proxy());
    }

    @Test
    public void testPutBytesWithByteArray() {
        this.mockHasher.expects(this.once()).method("putBytes");
        ChecksumProvider actual = this.abstractChecksumProvider.putBytes("abc".getBytes());
        Assert.assertTrue((boolean)(actual instanceof AbstractChecksumProvider));
    }

    @Test
    public void testPutBytesWithByteBuffer() {
        this.mockHasher.expects(this.once()).method("putBytes");
        ChecksumProvider actual = this.abstractChecksumProvider.putBytes(ByteBuffer.wrap("abc".getBytes()));
        Assert.assertTrue((boolean)(actual instanceof AbstractChecksumProvider));
    }
}

