/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import thredds.client.catalog.ServiceType;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.nc2.util.EscapeStrings;
import ucar.unidata.util.StringUtil2;
import ucar.unidata.util.Urlencoded;

public class DatasetUrl {
    private static final String alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String slashalpha = "\\/abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String[] FRAGPROTOCOLS = new String[]{"dap4", "dap2", "dods", "cdmremote", "thredds", "ncml"};
    private static final ServiceType[] FRAGPROTOSVCTYPE = new ServiceType[]{ServiceType.DAP4, ServiceType.OPENDAP, ServiceType.OPENDAP, ServiceType.THREDDS, ServiceType.THREDDS, ServiceType.NCML};
    private static int NUM_BYTES_TO_DETERMINE_NCML = 128;
    @Deprecated
    public final ServiceType serviceType;
    @Deprecated
    public final String trueurl;

    @VisibleForTesting
    public static List<String> getProtocols(String url) {
        ArrayList<String> allprotocols = new ArrayList<String>();
        StringBuilder buf = new StringBuilder(url);
        int slashpos = buf.indexOf("/");
        if (url.startsWith("file:") && "/\\".indexOf(url.charAt(5)) < 0) {
            allprotocols.add("file");
        } else if (url.startsWith("cdms3:") && "/\\".indexOf(url.charAt(6)) < 0) {
            allprotocols.add("cdms3");
        } else if (slashpos >= 0) {
            buf.delete(slashpos + 1, buf.length());
            int index = buf.indexOf(":");
            while (index > 0 && DatasetUrl.validateProtocol(buf, 0, index)) {
                String protocol = buf.substring(0, index);
                allprotocols.add(protocol);
                buf.delete(0, index + 1);
                index = buf.indexOf(":");
            }
        }
        return allprotocols;
    }

    private static boolean validateProtocol(StringBuilder buf, int startpos, int endpos) {
        int len = endpos - startpos;
        if (len == 0) {
            return false;
        }
        char cs = buf.charAt(startpos);
        char ce1 = buf.charAt(endpos + 1);
        String wtf = "/\\";
        if (len == 1 && alpha.indexOf(cs) >= 0 && (ce1 == '/' || ce1 == '\\')) {
            return false;
        }
        return slashalpha.indexOf(ce1) >= 0;
    }

    public static DatasetUrl findDatasetUrl(String orgLocation) throws IOException {
        ServiceType serviceType = null;
        String location = StringUtil2.replace(orgLocation.trim(), '\\', "/");
        List<String> allProtocols = DatasetUrl.getProtocols(location);
        String trueUrl = location;
        String leadProtocol = allProtocols.isEmpty() ? "file" : allProtocols.get(0);
        String fragment = null;
        int pos = trueUrl.lastIndexOf(35);
        if (pos >= 0) {
            fragment = trueUrl.substring(pos + 1);
            trueUrl = trueUrl.substring(0, pos);
        }
        pos = location.lastIndexOf(63);
        String query = null;
        if (pos >= 0 && !leadProtocol.equals("cdms3")) {
            query = trueUrl.substring(pos + 1);
            trueUrl = trueUrl.substring(0, pos);
        }
        if (fragment != null) {
            serviceType = DatasetUrl.searchFragment(fragment);
        }
        if (serviceType == null) {
            serviceType = DatasetUrl.decodeLeadProtocol(leadProtocol);
        }
        if (serviceType == null) {
            serviceType = DatasetUrl.searchPath(trueUrl);
        }
        if (serviceType == null) {
            if (leadProtocol.equals("file") || leadProtocol.equals("cdms3")) {
                serviceType = DatasetUrl.decodePathExtension(trueUrl);
                if (serviceType == null && !leadProtocol.equals("cdms3") && DatasetUrl.checkIfNcml(new File(location))) {
                    serviceType = ServiceType.NCML;
                }
            } else {
                serviceType = DatasetUrl.disambiguateHttp(trueUrl);
                if ((serviceType == null || serviceType == ServiceType.HTTPServer) && DatasetUrl.checkIfRemoteNcml(trueUrl)) {
                    serviceType = ServiceType.NCML;
                }
            }
        }
        if (serviceType == ServiceType.NCML) {
            String string = trueUrl = allProtocols.isEmpty() ? "file:" + trueUrl : trueUrl;
        }
        if (query != null || fragment != null) {
            StringBuilder buf = new StringBuilder(trueUrl);
            if (query != null) {
                buf.append('?');
                buf.append(query);
            }
            if (fragment != null) {
                buf.append('#');
                buf.append(fragment);
            }
            trueUrl = buf.toString();
        }
        return DatasetUrl.create(serviceType, trueUrl);
    }

    private static ServiceType searchFragment(String fragment) {
        if (fragment.isEmpty()) {
            return null;
        }
        Map<String, String> map = DatasetUrl.parseFragment(fragment);
        if (map == null) {
            return null;
        }
        String protocol = map.get("protocol");
        if (protocol == null) {
            for (String p : FRAGPROTOCOLS) {
                if (map.get(p) == null) continue;
                protocol = p;
                break;
            }
        }
        if (protocol != null) {
            if (protocol.equalsIgnoreCase("dap") || protocol.equalsIgnoreCase("dods")) {
                return ServiceType.OPENDAP;
            }
            if (protocol.equalsIgnoreCase("dap4")) {
                return ServiceType.DAP4;
            }
            if (protocol.equalsIgnoreCase("cdmremote")) {
                return ServiceType.CdmRemote;
            }
            if (protocol.equalsIgnoreCase("thredds")) {
                return ServiceType.THREDDS;
            }
            if (protocol.equalsIgnoreCase("ncml")) {
                return ServiceType.NCML;
            }
        }
        return null;
    }

    private static Map<String, String> parseFragment(String fragment) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (fragment != null && fragment.length() >= 0) {
            String[] pairs;
            if (fragment.charAt(0) == '#') {
                fragment = fragment.substring(1);
            }
            block4: for (String pair : pairs = fragment.split("[ \t]*[&][ \t]*")) {
                String[] pieces = pair.split("[ \t]*[=][ \t]*");
                switch (pieces.length) {
                    case 1: {
                        map.put(EscapeStrings.unescapeURL(pieces[0]).toLowerCase(), "true");
                        continue block4;
                    }
                    case 2: {
                        map.put(EscapeStrings.unescapeURL(pieces[0]).toLowerCase(), EscapeStrings.unescapeURL(pieces[1]).toLowerCase());
                        continue block4;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        return map;
    }

    private static ServiceType searchPath(String url) {
        return null;
    }

    private static ServiceType decodePathExtension(String path) {
        if (path.endsWith(".dds") || path.endsWith(".das") || path.endsWith(".dods")) {
            return ServiceType.OPENDAP;
        }
        if (path.matches("^.*[.](dmr|dap|dsr)([.](xml|html))?$")) {
            return ServiceType.DAP4;
        }
        if (path.endsWith(".xml") || path.endsWith(".ncml")) {
            return ServiceType.NCML;
        }
        return null;
    }

    @Urlencoded
    private static ServiceType decodeLeadProtocol(String protocol) {
        switch (protocol) {
            case "dods": {
                return ServiceType.OPENDAP;
            }
            case "dap4": {
                return ServiceType.DAP4;
            }
            case "httpserver": 
            case "nodods": {
                return ServiceType.HTTPServer;
            }
            case "cdmremote": {
                return ServiceType.CdmRemote;
            }
            case "thredds": {
                return ServiceType.THREDDS;
            }
        }
        return null;
    }

    @Urlencoded
    private static ServiceType disambiguateHttp(String location) throws IOException {
        ServiceType result;
        boolean checkDap2 = false;
        boolean checkDap4 = false;
        boolean checkCdmr = false;
        if (!location.startsWith("http")) {
            return null;
        }
        if (location.contains("cdmremote")) {
            result = DatasetUrl.checkIfCdmr(location);
            if (result != null) {
                return result;
            }
            checkCdmr = true;
        }
        if (location.contains("dodsC")) {
            result = DatasetUrl.checkIfDods(location);
            if (result != null) {
                return result;
            }
            checkDap2 = true;
        }
        if (location.contains("dap4") || location.contains("d4ts")) {
            result = DatasetUrl.checkIfDap4(location);
            if (result != null) {
                return result;
            }
            checkDap4 = true;
        }
        if (!checkDap2 && (result = DatasetUrl.checkIfDods(location)) != null) {
            return result;
        }
        if (!checkDap4 && (result = DatasetUrl.checkIfDap4(location)) != null) {
            return result;
        }
        if (!checkCdmr) {
            result = DatasetUrl.checkIfCdmr(location);
            return result;
        }
        return null;
    }

    private static ServiceType checkIfCdmr(String location) throws IOException {
        try (HTTPMethod method = HTTPFactory.Head((String)(location + "?req=header"));){
            int statusCode = method.execute();
            if (statusCode >= 300) {
                if (statusCode == 401 || statusCode == 403) {
                    throw new IOException("Unauthorized to open dataset " + location);
                }
                throw new IOException(location + " is not a valid URL, return status=" + statusCode);
            }
            Optional value = method.getResponseHeaderValue("Content-Description");
            ServiceType serviceType = value.map(v -> v.equalsIgnoreCase("ncstream") ? ServiceType.CdmRemote : null).orElse(null);
            return serviceType;
        }
    }

    private static ServiceType checkIfDods(String location) throws IOException {
        int len = location.length();
        if (location.endsWith(".dds")) {
            location = location.substring(0, len - ".dds".length());
        }
        if (location.endsWith(".das")) {
            location = location.substring(0, len - ".das".length());
        }
        if (location.endsWith(".dods")) {
            location = location.substring(0, len - ".dods".length());
        }
        try (HTTPMethod method = HTTPFactory.Get((String)(location + ".dds"));){
            Optional value;
            int status = method.execute();
            if (status == 200 && (value = method.getResponseHeaderValue("Content-Description")).isPresent()) {
                String v = (String)value.get();
                if (v.equalsIgnoreCase("dods-dds") || v.equalsIgnoreCase("dods_dds")) {
                    ServiceType serviceType = ServiceType.OPENDAP;
                    return serviceType;
                }
                throw new IOException("OPeNDAP Server Error= " + method.getResponseAsString());
            }
            if (status == 401 || status == 403) {
                throw new IOException("Unauthorized to open dataset " + location);
            }
            ServiceType serviceType = null;
            return serviceType;
        }
    }

    private static ServiceType checkIfDap4(String location) throws IOException {
        if (location.matches("^.*[.](dmr|dap|dsr)([.](xml|html))?$")) {
            if (location.endsWith(".xml")) {
                location = location.substring(0, location.length() - ".xml".length());
            } else if (location.endsWith(".html")) {
                location = location.substring(0, location.length() - ".html".length());
            }
            location = location.substring(0, location.length() - ".dxx".length());
        }
        location = location + ".dsr.xml";
        try (HTTPMethod method = HTTPFactory.Get((String)location);){
            Optional value;
            int status = method.execute();
            if (status == 200 && (value = method.getResponseHeaderValue("Content-Description")).isPresent() && ((String)value.get()).contains("application/vnd.opendap.dap4")) {
                ServiceType serviceType = ServiceType.DAP4;
                return serviceType;
            }
            ServiceType serviceType = null;
            return serviceType;
        }
    }

    private static boolean checkIfRemoteNcml(String location) throws IOException {
        if (!location.startsWith("http")) {
            return false;
        }
        if (DatasetUrl.decodePathExtension(location) == ServiceType.NCML) {
            try (HTTPMethod method = HTTPFactory.Get((String)location);){
                method.setRange(0L, (long)NUM_BYTES_TO_DETERMINE_NCML);
                method.setRequestHeader("accept-encoding", "identity");
                int statusCode = method.execute();
                if (statusCode >= 300) {
                    if (statusCode == 401) {
                        throw new IOException("Unauthorized to open dataset " + location);
                    }
                    if (statusCode == 406) {
                        String msg = location + " - this server does not support returning content without any encoding.";
                        msg = msg + " Please download the file locally. Return status=" + statusCode;
                        throw new IOException(msg);
                    }
                    throw new IOException(location + " is not a valid URL, return status=" + statusCode);
                }
                boolean bl = DatasetUrl.checkIfNcml(method.getResponseAsString());
                return bl;
            }
        }
        return false;
    }

    private static boolean checkIfNcml(File file) throws IOException {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), NUM_BYTES_TO_DETERMINE_NCML);){
            byte[] bytes = new byte[NUM_BYTES_TO_DETERMINE_NCML];
            int bytesRead = in.read(bytes);
            if (bytesRead <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = DatasetUrl.checkIfNcml(new String(bytes, 0, bytesRead));
            return bl;
        }
    }

    private static boolean checkIfNcml(String string) {
        return string.contains("<netcdf ") && string.contains("unidata.ucar.edu/namespaces/netcdf/ncml");
    }

    public static DatasetUrl create(@Nullable ServiceType serviceType, String trueurl) {
        return new DatasetUrl(serviceType, trueurl);
    }

    @Deprecated
    public DatasetUrl(ServiceType serviceType, String trueurl) {
        this.serviceType = serviceType;
        this.trueurl = trueurl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetUrl that = (DatasetUrl)o;
        return this.serviceType == that.serviceType && Objects.equals(this.trueurl, that.trueurl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serviceType, this.trueurl});
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public String getTrueurl() {
        return this.trueurl;
    }
}

