/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.IQuery;
import ome.parameters.Parameters;
import ome.services.query.ModelObjectCache;

public class HierarchyNavigator {
    private static final ImmutableMap<Map.Entry<String, String>, String> hqlFromTo;
    protected final IQuery iQuery;
    private final ModelObjectCache cache = new ModelObjectCache();

    protected HierarchyNavigator(IQuery iQuery) {
        this.iQuery = iQuery;
    }

    private List<Object[]> doQuery(String toType, String fromType, Collection<Long> fromIds) {
        String queryString = (String)hqlFromTo.get(new AbstractMap.SimpleImmutableEntry<String, String>(fromType, toType));
        if (queryString == null) {
            throw new IllegalArgumentException("not implemented for " + fromType + " to " + toType);
        }
        return this.iQuery.projection(queryString, new Parameters().addIds(fromIds));
    }

    protected void prepareLookups(String toType, String fromType, Collection<Long> fromIds) {
        HashSet<Long> fromIdsToQuery = new HashSet<Long>(fromIds);
        for (long fromId : fromIds) {
            if (this.cache.getFromCache(fromType, fromId, toType) == null) continue;
            fromIdsToQuery.remove(fromId);
        }
        if (fromIdsToQuery.isEmpty()) {
            return;
        }
        HashMultimap fromIdsToIds = HashMultimap.create();
        for (List list : Iterables.partition(fromIdsToQuery, (int)256)) {
            for (Object[] queryResult : this.doQuery(toType, fromType, list)) {
                fromIdsToIds.put((Object)((Long)queryResult[0]), (Object)((Long)queryResult[1]));
            }
        }
        for (Map.Entry entry : fromIdsToIds.asMap().entrySet()) {
            this.cache.putIntoCache(fromType, (Long)entry.getKey(), toType, (ImmutableSet<Long>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        for (Long l : Sets.difference(fromIdsToQuery, (Set)fromIdsToIds.keySet())) {
            this.cache.putIntoCache(fromType, l, toType, (ImmutableSet<Long>)ImmutableSet.of());
        }
    }

    protected ImmutableSet<Long> doLookup(String toType, String fromType, Long fromId) {
        ImmutableSet<Long> result = this.cache.getFromCache(fromType, fromId, toType);
        if (result == null) {
            ImmutableSet.Builder toIdsBuilder = ImmutableSet.builder();
            for (Object[] queryResult : this.doQuery(toType, fromType, Collections.singleton(fromId))) {
                toIdsBuilder.add((Object)((Long)queryResult[1]));
            }
            ImmutableSet toIds = toIdsBuilder.build();
            this.cache.putIntoCache(fromType, fromId, toType, (ImmutableSet<Long>)toIds);
            return toIds;
        }
        return result;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Folder", "Folder"), (Object)"SELECT parentFolder.id, id FROM Folder WHERE parentFolder.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Folder", "Image"), (Object)"SELECT parent.id, child.id FROM FolderImageLink WHERE parent.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Project", "Dataset"), (Object)"SELECT parent.id, child.id FROM ProjectDatasetLink WHERE parent.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Dataset", "Image"), (Object)"SELECT parent.id, child.id FROM DatasetImageLink WHERE parent.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Screen", "Plate"), (Object)"SELECT parent.id, child.id FROM ScreenPlateLink WHERE parent.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Plate", "Well"), (Object)"SELECT plate.id, id FROM Well WHERE plate.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Well", "Image"), (Object)"SELECT well.id, image.id FROM WellSample WHERE well.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Fileset", "Image"), (Object)"SELECT fileset.id, id FROM Image WHERE fileset.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Image", "Fileset"), (Object)"SELECT id, fileset.id FROM Image WHERE fileset.id IS NOT NULL AND id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Image", "Well"), (Object)"SELECT image.id, well.id FROM WellSample WHERE image.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Well", "Plate"), (Object)"SELECT id, plate.id FROM Well WHERE id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Plate", "Screen"), (Object)"SELECT child.id, parent.id FROM ScreenPlateLink WHERE child.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Image", "Dataset"), (Object)"SELECT child.id, parent.id FROM DatasetImageLink WHERE child.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Dataset", "Project"), (Object)"SELECT child.id, parent.id FROM ProjectDatasetLink WHERE child.id IN (:ids)");
        builder.put(new AbstractMap.SimpleImmutableEntry<String, String>("Image", "Folder"), (Object)"SELECT child.id, parent.id FROM FolderImageLink WHERE child.id IN (:ids)");
        hqlFromTo = builder.build();
    }
}

